//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qpixmap_c.h"

QPixmapH QPixmap_create()
{
	return (QPixmapH) new QPixmap();
}

void QPixmap_destroy(QPixmapH handle)
{
	delete (QPixmap *)handle;
}

QPixmapH QPixmap_create2(int w, int h)
{
	return (QPixmapH) new QPixmap(w, h);
}

QPixmapH QPixmap_create3(const QSizeH p1)
{
	return (QPixmapH) new QPixmap(*(const QSize*)p1);
}

QPixmapH QPixmap_create4(PWideString fileName, const char* format, unsigned int flags)
{
	QString t_fileName;
	copyPWideStringToQString(fileName, t_fileName);
	return (QPixmapH) new QPixmap(t_fileName, format, (Qt::ImageConversionFlags)flags);
}

QPixmapH QPixmap_create5(const char* const xpm)
{
	return (QPixmapH) new QPixmap(xpm);
}

QPixmapH QPixmap_create6(const QPixmapH p1)
{
	return (QPixmapH) new QPixmap(*(const QPixmap*)p1);
}

bool QPixmap_isNull(QPixmapH handle)
{
	return (bool) ((QPixmap *)handle)->isNull();
}

int QPixmap_devType(QPixmapH handle)
{
	return (int) ((QPixmap *)handle)->devType();
}

int QPixmap_width(QPixmapH handle)
{
	return (int) ((QPixmap *)handle)->width();
}

int QPixmap_height(QPixmapH handle)
{
	return (int) ((QPixmap *)handle)->height();
}

void QPixmap_size(QPixmapH handle, PSize retval)
{
	*(QSize *)retval = ((QPixmap *)handle)->size();
}

void QPixmap_rect(QPixmapH handle, PRect retval)
{
	QRect t_retval;
	t_retval = ((QPixmap *)handle)->rect();
	copyQRectToPRect(t_retval, retval);
}

int QPixmap_depth(QPixmapH handle)
{
	return (int) ((QPixmap *)handle)->depth();
}

int QPixmap_defaultDepth()
{
	return (int) QPixmap::defaultDepth();
}

void QPixmap_fill(QPixmapH handle, const QColorH fillColor)
{
	((QPixmap *)handle)->fill(*(const QColor*)fillColor);
}

void QPixmap_fill2(QPixmapH handle, const QWidgetH widget, const QPointH ofs)
{
	((QPixmap *)handle)->fill((const QWidget*)widget, *(const QPoint*)ofs);
}

void QPixmap_fill3(QPixmapH handle, const QWidgetH widget, int xofs, int yofs)
{
	((QPixmap *)handle)->fill((const QWidget*)widget, xofs, yofs);
}

void QPixmap_mask(QPixmapH handle, QBitmapH retval)
{
	*(QBitmap *)retval = ((QPixmap *)handle)->mask();
}

void QPixmap_setMask(QPixmapH handle, const QBitmapH p1)
{
	((QPixmap *)handle)->setMask(*(const QBitmap*)p1);
}

void QPixmap_alphaChannel(QPixmapH handle, QPixmapH retval)
{
	*(QPixmap *)retval = ((QPixmap *)handle)->alphaChannel();
}

void QPixmap_setAlphaChannel(QPixmapH handle, const QPixmapH p1)
{
	((QPixmap *)handle)->setAlphaChannel(*(const QPixmap*)p1);
}

bool QPixmap_hasAlpha(QPixmapH handle)
{
	return (bool) ((QPixmap *)handle)->hasAlpha();
}

bool QPixmap_hasAlphaChannel(QPixmapH handle)
{
	return (bool) ((QPixmap *)handle)->hasAlphaChannel();
}

void QPixmap_createHeuristicMask(QPixmapH handle, QBitmapH retval, bool clipTight)
{
	*(QBitmap *)retval = ((QPixmap *)handle)->createHeuristicMask(clipTight);
}

void QPixmap_createMaskFromColor(QPixmapH handle, QBitmapH retval, const QColorH maskColor)
{
	*(QBitmap *)retval = ((QPixmap *)handle)->createMaskFromColor(*(const QColor*)maskColor);
}

void QPixmap_createMaskFromColor2(QPixmapH handle, QBitmapH retval, const QColorH maskColor, Qt::MaskMode mode)
{
	*(QBitmap *)retval = ((QPixmap *)handle)->createMaskFromColor(*(const QColor*)maskColor, mode);
}

void QPixmap_grabWindow(QPixmapH retval, unsigned int p1, int x, int y, int w, int h)
{
	*(QPixmap *)retval = QPixmap::grabWindow((WId)p1, x, y, w, h);
}

void QPixmap_grabWidget(QPixmapH retval, QWidgetH widget, PRect rect)
{
	QRect t_rect;
	copyPRectToQRect(rect, t_rect);
	*(QPixmap *)retval = QPixmap::grabWidget((QWidget*)widget, t_rect);
}

void QPixmap_grabWidget2(QPixmapH retval, QWidgetH widget, int x, int y, int w, int h)
{
	*(QPixmap *)retval = QPixmap::grabWidget((QWidget*)widget, x, y, w, h);
}

void QPixmap_scaled(QPixmapH handle, QPixmapH retval, int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)
{
	*(QPixmap *)retval = ((QPixmap *)handle)->scaled(w, h, aspectMode, mode);
}

void QPixmap_scaled2(QPixmapH handle, QPixmapH retval, const QSizeH s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)
{
	*(QPixmap *)retval = ((QPixmap *)handle)->scaled(*(const QSize*)s, aspectMode, mode);
}

void QPixmap_scaledToWidth(QPixmapH handle, QPixmapH retval, int w, Qt::TransformationMode mode)
{
	*(QPixmap *)retval = ((QPixmap *)handle)->scaledToWidth(w, mode);
}

void QPixmap_scaledToHeight(QPixmapH handle, QPixmapH retval, int h, Qt::TransformationMode mode)
{
	*(QPixmap *)retval = ((QPixmap *)handle)->scaledToHeight(h, mode);
}

void QPixmap_transformed(QPixmapH handle, QPixmapH retval, const QMatrixH p1, Qt::TransformationMode mode)
{
	*(QPixmap *)retval = ((QPixmap *)handle)->transformed(*(const QMatrix*)p1, mode);
}

void QPixmap_trueMatrix(QMatrixH retval, const QMatrixH m, int w, int h)
{
	*(QMatrix *)retval = QPixmap::trueMatrix(*(const QMatrix*)m, w, h);
}

void QPixmap_transformed2(QPixmapH handle, QPixmapH retval, const QTransformH p1, Qt::TransformationMode mode)
{
	*(QPixmap *)retval = ((QPixmap *)handle)->transformed(*(const QTransform*)p1, mode);
}

void QPixmap_trueMatrix2(QTransformH retval, const QTransformH m, int w, int h)
{
	*(QTransform *)retval = QPixmap::trueMatrix(*(const QTransform*)m, w, h);
}

void QPixmap_toImage(QPixmapH handle, QImageH retval)
{
	*(QImage *)retval = ((QPixmap *)handle)->toImage();
}

void QPixmap_fromImage(QPixmapH retval, const QImageH image, unsigned int flags)
{
	*(QPixmap *)retval = QPixmap::fromImage(*(const QImage*)image, (Qt::ImageConversionFlags)flags);
}

bool QPixmap_load(QPixmapH handle, PWideString fileName, const char* format, unsigned int flags)
{
	QString t_fileName;
	copyPWideStringToQString(fileName, t_fileName);
	return (bool) ((QPixmap *)handle)->load(t_fileName, format, (Qt::ImageConversionFlags)flags);
}

bool QPixmap_loadFromData(QPixmapH handle, const uchar* buf, uint len, const char* format, unsigned int flags)
{
	return (bool) ((QPixmap *)handle)->loadFromData(buf, len, format, (Qt::ImageConversionFlags)flags);
}

bool QPixmap_loadFromData2(QPixmapH handle, const QByteArrayH data, const char* format, unsigned int flags)
{
	return (bool) ((QPixmap *)handle)->loadFromData(*(const QByteArray*)data, format, (Qt::ImageConversionFlags)flags);
}

bool QPixmap_save(QPixmapH handle, PWideString fileName, const char* format, int quality)
{
	QString t_fileName;
	copyPWideStringToQString(fileName, t_fileName);
	return (bool) ((QPixmap *)handle)->save(t_fileName, format, quality);
}

bool QPixmap_save2(QPixmapH handle, QIODeviceH device, const char* format, int quality)
{
	return (bool) ((QPixmap *)handle)->save((QIODevice*)device, format, quality);
}

void QPixmap_copy(QPixmapH handle, QPixmapH retval, int x, int y, int width, int height)
{
	*(QPixmap *)retval = ((QPixmap *)handle)->copy(x, y, width, height);
}

void QPixmap_copy2(QPixmapH handle, QPixmapH retval, PRect rect)
{
	QRect t_rect;
	copyPRectToQRect(rect, t_rect);
	*(QPixmap *)retval = ((QPixmap *)handle)->copy(t_rect);
}

int QPixmap_serialNumber(QPixmapH handle)
{
	return (int) ((QPixmap *)handle)->serialNumber();
}

qint64 QPixmap_cacheKey(QPixmapH handle)
{
	return (qint64) ((QPixmap *)handle)->cacheKey();
}

bool QPixmap_isDetached(QPixmapH handle)
{
	return (bool) ((QPixmap *)handle)->isDetached();
}

void QPixmap_detach(QPixmapH handle)
{
	((QPixmap *)handle)->detach();
}

bool QPixmap_isQBitmap(QPixmapH handle)
{
	return (bool) ((QPixmap *)handle)->isQBitmap();
}

#if defined BINUX
void QPixmap_fromX11Pixmap(QPixmapH retval, Qt::HANDLE pixmap, QPixmap::ShareMode mode)
{
	*(QPixmap *)retval = QPixmap::fromX11Pixmap(pixmap, mode);
}

int QPixmap_x11SetDefaultScreen(int screen)
{
	return (int) QPixmap::x11SetDefaultScreen(screen);
}

void QPixmap_x11SetScreen(QPixmapH handle, int screen)
{
	((QPixmap *)handle)->x11SetScreen(screen);
}

const QX11InfoH QPixmap_x11Info(QPixmapH handle)
{
	return (const QX11InfoH) &((QPixmap *)handle)->x11Info();
}

Qt::HANDLE QPixmap_x11PictureHandle(QPixmapH handle)
{
	return (Qt::HANDLE) ((QPixmap *)handle)->x11PictureHandle();
}

#endif
#if defined BINUX || QTOPIA
Qt::HANDLE QPixmap_handle(QPixmapH handle)
{
	return (Qt::HANDLE) ((QPixmap *)handle)->handle();
}

#endif
QPaintEngineH QPixmap_paintEngine(QPixmapH handle)
{
	return (QPaintEngineH) ((QPixmap *)handle)->paintEngine();
}

#if defined MSWINDOWS
HBITMAP QPixmap_toWinHBITMAP(QPixmapH handle, QPixmap::HBitmapFormat format)
{
	return (HBITMAP) ((QPixmap *)handle)->toWinHBITMAP(format);
}

void QPixmap_fromWinHBITMAP(QPixmapH retval, HBITMAP hbitmap, QPixmap::HBitmapFormat format)
{
	*(QPixmap *)retval = QPixmap::fromWinHBITMAP(hbitmap, format);
}

#endif
#if defined DARWIN
CGImageRef QPixmap_toMacCGImageRef(QPixmapH handle)
{
	return (CGImageRef) ((QPixmap *)handle)->toMacCGImageRef();
}

void QPixmap_fromMacCGImageRef(QPixmapH retval, CGImageRef image)
{
	*(QPixmap *)retval = QPixmap::fromMacCGImageRef(image);
}

Qt::HANDLE QPixmap_macQDHandle(QPixmapH handle)
{
	return (Qt::HANDLE) ((QPixmap *)handle)->macQDHandle();
}

Qt::HANDLE QPixmap_macQDAlphaHandle(QPixmapH handle)
{
	return (Qt::HANDLE) ((QPixmap *)handle)->macQDAlphaHandle();
}

Qt::HANDLE QPixmap_macCGHandle(QPixmapH handle)
{
	return (Qt::HANDLE) ((QPixmap *)handle)->macCGHandle();
}

#endif
#if defined QTOPIA
const uchar* QPixmap_qwsBits(QPixmapH handle)
{
	return (const uchar*) ((QPixmap *)handle)->qwsBits();
}

int QPixmap_qwsBytesPerLine(QPixmapH handle)
{
	return (int) ((QPixmap *)handle)->qwsBytesPerLine();
}

QRgb * QPixmap_clut(QPixmapH handle)
{
	return (QRgb *) ((QPixmap *)handle)->clut();
}

int QPixmap_numCols(QPixmapH handle)
{
	return (int) ((QPixmap *)handle)->numCols();
}

#endif
