//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qobject_c.h"

QObjectH QObject_create(QObjectH parent)
{
	return (QObjectH) new QObject((QObject*)parent);
}

void QObject_destroy(QObjectH handle)
{
	delete (QObject *)handle;
}

bool QObject_event(QObjectH handle, QEventH p1)
{
	return (bool) ((QObject *)handle)->event((QEvent*)p1);
}

bool QObject_eventFilter(QObjectH handle, QObjectH p1, QEventH p2)
{
	return (bool) ((QObject *)handle)->eventFilter((QObject*)p1, (QEvent*)p2);
}

void QObject_tr(PWideString retval, const char* sourceText, const char* comment, int n)
{
	QString t_retval;
	t_retval = QObject::tr(sourceText, comment, n);
	copyQStringToPWideString(t_retval, retval);
}

void QObject_trUtf8(PWideString retval, const char* sourceText, const char* comment, int n)
{
	QString t_retval;
	t_retval = QObject::trUtf8(sourceText, comment, n);
	copyQStringToPWideString(t_retval, retval);
}

const QMetaObjectH QObject_metaObject(QObjectH handle)
{
	return (const QMetaObjectH) ((QObject *)handle)->metaObject();
}

void QObject_objectName(QObjectH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QObject *)handle)->objectName();
	copyQStringToPWideString(t_retval, retval);
}

void QObject_setObjectName(QObjectH handle, PWideString name)
{
	QString t_name;
	copyPWideStringToQString(name, t_name);
	((QObject *)handle)->setObjectName(t_name);
}

bool QObject_isWidgetType(QObjectH handle)
{
	return (bool) ((QObject *)handle)->isWidgetType();
}

bool QObject_signalsBlocked(QObjectH handle)
{
	return (bool) ((QObject *)handle)->signalsBlocked();
}

bool QObject_blockSignals(QObjectH handle, bool b)
{
	return (bool) ((QObject *)handle)->blockSignals(b);
}

QThreadH QObject_thread(QObjectH handle)
{
	return (QThreadH) ((QObject *)handle)->thread();
}

void QObject_moveToThread(QObjectH handle, QThreadH thread)
{
	((QObject *)handle)->moveToThread((QThread*)thread);
}

int QObject_startTimer(QObjectH handle, int interval)
{
	return (int) ((QObject *)handle)->startTimer(interval);
}

void QObject_killTimer(QObjectH handle, int id)
{
	((QObject *)handle)->killTimer(id);
}

void QObject_children(QObjectH handle, PPtrIntArray retval)
{
	QObjectList t_retval;
	t_retval = ((QObject *)handle)->children();
	copyQListTemplateToPtrIntArray(t_retval, retval);
}

void QObject_setParent(QObjectH handle, QObjectH p1)
{
	((QObject *)handle)->setParent((QObject*)p1);
}

void QObject_installEventFilter(QObjectH handle, QObjectH p1)
{
	((QObject *)handle)->installEventFilter((QObject*)p1);
}

void QObject_removeEventFilter(QObjectH handle, QObjectH p1)
{
	((QObject *)handle)->removeEventFilter((QObject*)p1);
}

bool QObject_connect(const QObjectH sender, const char* signal, const QObjectH receiver, const char* member, Qt::ConnectionType p5)
{
	return (bool) QObject::connect((const QObject*)sender, signal, (const QObject*)receiver, member, p5);
}

bool QObject_connect2(QObjectH handle, const QObjectH sender, const char* signal, const char* member, Qt::ConnectionType type)
{
	return (bool) ((QObject *)handle)->connect((const QObject*)sender, signal, member, type);
}

bool QObject_disconnect(const QObjectH sender, const char* signal, const QObjectH receiver, const char* member)
{
	return (bool) QObject::disconnect((const QObject*)sender, signal, (const QObject*)receiver, member);
}

bool QObject_disconnect3(QObjectH handle, const QObjectH receiver, const char* member)
{
	return (bool) ((QObject *)handle)->disconnect((const QObject*)receiver, member);
}

void QObject_dumpObjectTree(QObjectH handle)
{
	((QObject *)handle)->dumpObjectTree();
}

void QObject_dumpObjectInfo(QObjectH handle)
{
	((QObject *)handle)->dumpObjectInfo();
}

bool QObject_setProperty(QObjectH handle, const char* name, const QVariantH value)
{
	return (bool) ((QObject *)handle)->setProperty(name, *(const QVariant*)value);
}

void QObject_property(QObjectH handle, QVariantH retval, const char* name)
{
	*(QVariant *)retval = ((QObject *)handle)->property(name);
}

uint QObject_registerUserData()
{
	return (uint) QObject::registerUserData();
}

QObjectH QObject_parent(QObjectH handle)
{
	return (QObjectH) ((QObject *)handle)->parent();
}

bool QObject_inherits(QObjectH handle, const char* classname)
{
	return (bool) ((QObject *)handle)->inherits(classname);
}

void QObject_deleteLater(QObjectH handle)
{
	((QObject *)handle)->deleteLater();
}

