//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QNETWORKCOOKIE_C_H
#define QNETWORKCOOKIE_C_H

#include <QtNetwork>
#include "pascalbind.h"

C_EXPORT QNetworkCookieH QNetworkCookie_create(const QByteArrayH name, const QByteArrayH value);
C_EXPORT void QNetworkCookie_destroy(QNetworkCookieH handle);
C_EXPORT QNetworkCookieH QNetworkCookie_create2(const QNetworkCookieH other);
C_EXPORT bool QNetworkCookie_isSecure(QNetworkCookieH handle);
C_EXPORT void QNetworkCookie_setSecure(QNetworkCookieH handle, bool enable);
C_EXPORT bool QNetworkCookie_isHttpOnly(QNetworkCookieH handle);
C_EXPORT void QNetworkCookie_setHttpOnly(QNetworkCookieH handle, bool enable);
C_EXPORT bool QNetworkCookie_isSessionCookie(QNetworkCookieH handle);
C_EXPORT void QNetworkCookie_expirationDate(QNetworkCookieH handle, QDateTimeH retval);
C_EXPORT void QNetworkCookie_setExpirationDate(QNetworkCookieH handle, const QDateTimeH date);
C_EXPORT void QNetworkCookie_domain(QNetworkCookieH handle, PWideString retval);
C_EXPORT void QNetworkCookie_setDomain(QNetworkCookieH handle, PWideString domain);
C_EXPORT void QNetworkCookie_path(QNetworkCookieH handle, PWideString retval);
C_EXPORT void QNetworkCookie_setPath(QNetworkCookieH handle, PWideString path);
C_EXPORT void QNetworkCookie_name(QNetworkCookieH handle, QByteArrayH retval);
C_EXPORT void QNetworkCookie_setName(QNetworkCookieH handle, const QByteArrayH cookieName);
C_EXPORT void QNetworkCookie_value(QNetworkCookieH handle, QByteArrayH retval);
C_EXPORT void QNetworkCookie_setValue(QNetworkCookieH handle, const QByteArrayH value);
C_EXPORT void QNetworkCookie_toRawForm(QNetworkCookieH handle, QByteArrayH retval, QNetworkCookie::RawForm form);
C_EXPORT QNetworkCookieJarH QNetworkCookieJar_create(QObjectH parent);
C_EXPORT void QNetworkCookieJar_destroy(QNetworkCookieJarH handle);

#endif
