/* hashKey.h
 */
#ifndef _HASH_KEY_H
#define _HASH_KEY_H

#include "osl/config.h"
#include "osl/hash/boardKey.h"
#include "osl/piece.h"
#include "osl/move.h"
#include "osl/pieceStand.h"
#include "osl/state/simpleState.h"
#include "osl/misc/carray.h"

namespace osl
{
  namespace hash
  {
#if OSL_WORDSIZE == 64
    typedef HashKey64 HashKeyBase;
    typedef BoardKey64 BoardKey;
#elif OSL_WORDSIZE == 32
    typedef HashKey32 HashKeyBase;
    typedef BoardKey32 BoardKey;
#endif
    class HashKey : public HashKeyBase
    {
    public:
      HashKey() :HashKeyBase(){}
      HashKey(const SimpleState&);
      const HashKey newHashWithMove(Move move) const;

      const HashKey newMakeMove(Move) const;
      const HashKey newUnmakeMove(Move) const;

      void dumpContents(std::ostream& os) const;
      void dumpContentsCerr() const;
      static const HashKey readFromDump(const std::string&);
      static const HashKey readFromDump(std::istream&);
    };
    std::ostream& operator<<(std::ostream& os,const HashKey& h);

    class HashGenTable
    {
      CArray2d<HashKey,Square::SIZE,PTYPEO_SIZE> hashKey;
    public:
      HashGenTable();
      void addHashKey(HashKey& hk,Square pos,PtypeO ptypeo) const{
	assert(pos.isValid() && isValidPtypeO(ptypeo));
	hk+=hashKey[pos.index()][ptypeo-PTYPEO_MIN];
      }
      void subHashKey(HashKey& hk,Square pos,PtypeO ptypeo) const{
	assert(pos.isValid() && isValidPtypeO(ptypeo));
	hk-=hashKey[pos.index()][ptypeo-PTYPEO_MIN];
      }
    };
    extern const HashGenTable Hash_Gen_Table;

  } // namespace hash
  using hash::HashKey;
  using hash::BoardKey;

  namespace stl
  {
    template <typename T> struct hash;
    template <>
    struct hash<osl::hash::HashKey>{
      unsigned long operator()(const HashKey& h) const{
	return h.signature();
      }
    };
    template<>
    struct hash<osl::hash::BoardKey>
    {
      unsigned long operator()(const BoardKey& h) const
      {
	return h.signature();
      }
    };
  } // namespace stl
#ifdef USE_TBB_HASH
  struct TBBHashCompare
  {
    size_t hash(HashKey const& key) const {
      return (size_t)(key.signature());
    }
    bool equal(HashKey const& key1, HashKey const& key2) const {
      return key1==key2;
    }
  };
  struct TBBSignatureCompare
  {
    size_t hash(hash::BoardKey const& key) const {
      return (size_t)key.signature();
    }
    bool equal(hash::BoardKey const& key1, hash::BoardKey const& key2) const {
      return key1==key2;
    }
  };
#endif
} // namespace osl

#endif /* _HASH_KEY_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
