/* countMobility.t.cc
 */
#include "osl/mobility/countMobility.h"
#include "osl/record/csaString.h"
#include <iostream>

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class CountMobilityTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(CountMobilityTest);
  CPPUNIT_TEST(testCount);
  CPPUNIT_TEST_SUITE_END();
public:
  void testCount();
};

CPPUNIT_TEST_SUITE_REGISTRATION(CountMobilityTest);

using namespace osl;
using namespace osl::mobility;

void CountMobilityTest::testCount()
{
  {
    SimpleState sState=
      CsaString(
		"P1+NY+TO *  *  *  * -OU-KE-KY\n"
		"P2 *  *  *  *  * -GI-FU *  *\n"
		"P3 * +RY *  * +UM * -KI-FU-FU\n"
		"P4 *  * +FU-KI *  *  *  *  *\n"
		"P5 *  * -KE * +FU *  * +FU *\n"
		"P6+KE *  * +FU+GI-FU *  * +FU\n"
		"P7 *  * -UM *  *  *  *  *  *\n"
		"P8 *  *  *  *  *  *  *  *  * \n"
		"P9 * +OU * -GI *  *  *  * -NG\n"
		"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
		"P-00KI00KY00FU00FU\n"
		"P-00AL\n"
		"+\n"
		).getInitialState();
    NumEffectState state(sState);
    // 83 飛車 
    {
      const Square pos(8,3);
      {
	const Offset o(0,-1);
	CPPUNIT_ASSERT_EQUAL(1,countMobilitySafe(BLACK,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(1,countMobilityAll(BLACK,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(BLACK,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(1,countAll);      
	CPPUNIT_ASSERT_EQUAL(1,countSafe);      
      }
      {
	const Offset o(0,1);
	CPPUNIT_ASSERT_EQUAL(5,countMobilityAll(BLACK,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(2,countMobilitySafe(BLACK,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(BLACK,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(5,countAll);      
	CPPUNIT_ASSERT_EQUAL(2,countSafe);      
      }
      {
	const Offset o(-1,0);
	CPPUNIT_ASSERT_EQUAL(2,countMobilityAll(BLACK,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(1,countMobilitySafe(BLACK,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(BLACK,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(2,countAll);      
	CPPUNIT_ASSERT_EQUAL(1,countSafe);      
      }
      {
	const Offset o(1,0);
	CPPUNIT_ASSERT_EQUAL(1,countMobilityAll(BLACK,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(1,countMobilitySafe(BLACK,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(BLACK,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(1,countAll);      
	CPPUNIT_ASSERT_EQUAL(1,countSafe);      
      }
    }
    // 53 馬
    {
      const Square pos(5,3);
      {
	const Offset o(-1,-1);
	CPPUNIT_ASSERT_EQUAL(1,countMobilityAll(BLACK,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(0,countMobilitySafe(BLACK,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(BLACK,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(1,countAll);      
	CPPUNIT_ASSERT_EQUAL(0,countSafe);      
      }
      {
	const Offset o(-1,1);
	CPPUNIT_ASSERT_EQUAL(4,countMobilityAll(BLACK,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(3,countMobilitySafe(BLACK,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(BLACK,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(4,countAll);      
	CPPUNIT_ASSERT_EQUAL(3,countSafe);      
      }
      {
	const Offset o(1,-1);
	CPPUNIT_ASSERT_EQUAL(2,countMobilityAll(BLACK,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(2,countMobilitySafe(BLACK,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(BLACK,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(2,countAll);      
	CPPUNIT_ASSERT_EQUAL(2,countSafe);      
      }
      {
	const Offset o(1,1);
	CPPUNIT_ASSERT_EQUAL(1,countMobilityAll(BLACK,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(1,countMobilitySafe(BLACK,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(BLACK,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(1,countAll);      
	CPPUNIT_ASSERT_EQUAL(1,countSafe);      
      }
    }
    // 77 馬
    {
      const Square pos(7,7);
      {
	const Offset o(-1,-1);
	CPPUNIT_ASSERT_EQUAL(1,countMobilityAll(WHITE,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(1,countMobilitySafe(WHITE,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(WHITE,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(1,countAll);      
	CPPUNIT_ASSERT_EQUAL(1,countSafe);      
      }
      {
	const Offset o(-1,1);
	CPPUNIT_ASSERT_EQUAL(2,countMobilityAll(WHITE,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(2,countMobilitySafe(WHITE,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(WHITE,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(2,countAll);      
	CPPUNIT_ASSERT_EQUAL(2,countSafe);      
      }
      {
	const Offset o(1,-1);
	CPPUNIT_ASSERT_EQUAL(2,countMobilityAll(WHITE,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(1,countMobilitySafe(WHITE,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(WHITE,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(2,countAll);      
	CPPUNIT_ASSERT_EQUAL(1,countSafe);      
      }
      {
	const Offset o(1,1);
	CPPUNIT_ASSERT_EQUAL(2,countMobilityAll(WHITE,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(0,countMobilitySafe(WHITE,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(WHITE,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(2,countAll);      
	CPPUNIT_ASSERT_EQUAL(0,countSafe);      
      }
    }
    // 11 香車
    {
      const Square pos(1,1);
      {
	const Offset o(0,1);
	CPPUNIT_ASSERT_EQUAL(1,countMobilityAll(WHITE,state,pos,o));
	CPPUNIT_ASSERT_EQUAL(1,countMobilitySafe(WHITE,state,pos,o));
	int countAll=0,countSafe=0;
	countMobilityBoth(WHITE,state,pos,o,countAll,countSafe);
	CPPUNIT_ASSERT_EQUAL(1,countAll);      
	CPPUNIT_ASSERT_EQUAL(1,countSafe);      
      }
    }
  }
}



/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
