/* checkmateIfCapture.cc
 */
#include "osl/checkmate/checkmateIfCapture.h"
#include "osl/checkmate/fixedDepthSearcher.h"
#include "osl/checkmate/king8Info.h"
#include "osl/checkmate/immediateCheckmate.h"
#include "osl/effect_util/effectUtil.h"
#include "osl/effect_util/neighboring8Direct.h"
#include "osl/move_generator/capture_.h"
#include "osl/move_action/store.h"
#include "osl/move_classifier/moveAdaptor.h"
#include "osl/move_classifier/openCheck.h"
#include "osl/apply_move/applyMove.h"
#include "osl/neighboring8.h"

struct osl::checkmate::CheckmateIfCapture::CallDefense
{
  NumEffectState *state;
  int depth;
  bool result;
  void operator()(Position last_to)
  {
    result = cannotCapture(*state, last_to, depth);
  }
};

bool osl::checkmate::
CheckmateIfCapture::effectiveAttackCandidate0(const NumEffectState& state, Move move)
{
  using namespace move_classifier;
  // depth 0 専用の枝刈
  const Player attacker = state.getTurn();
  const Player defender = alt(attacker);
  const Position king = state.getKingPosition(defender);
  PieceMask pieces = state.getEffect(move.to())
    & state.getOnBoardMask(defender);
  if (pieces.none())
    return false;
  if (Neighboring8::isNeighboring8(move.to(), king))
    return true;
  const Piece captured = state.getPieceOnBoard(move.to());
  if (move.capturePtype() != PTYPE_EMPTY) {
    if (Neighboring8Direct::hasEffect(state, captured.ptypeO(), 
				      move.to(), king))
      return true;
  }
  if (! move.isDrop()
      && (state.selectLong(move.from(), attacker).any() // todo: refinement 開き王手pinとか8近傍くらい?
	  || (Neighboring8::isNeighboring8(move.from(), king)
	      && state.hasEffectBy(attacker, move.from()))))
    return true;

  const King8Info info = state.king8Info(defender);
  const CArray<Position,2> knight_position = {{
      Board_Table.nextPosition(defender, king, UUR),
      Board_Table.nextPosition(defender, king, UUL)
    }};
  if (state.inCheck()
      && (info.dropCandidate() || info.moveCandidate2()
	  || /* only when has knight or knight effect */info.liberty() == 0))
    return true;
  if (move.capturePtype() != PTYPE_EMPTY) {
    if (info.dropCandidate())
      return true;
    if (info.liberty() == 0) {
      for (int i=0; i<2; ++i) {
	const Position kp = knight_position[i];
	const Piece kpp = state.getPieceAt(kp);
	if (kpp.isEdge() || state.hasEffectNotBy(defender, captured, kp))
	  continue;
	if (kpp.isEmpty()
	    && unpromote(move.capturePtype()) == KNIGHT)
	  return true;
	if (state.hasEffectByPiece(captured, kp)
	    && (unpromote(move.capturePtype()) == KNIGHT
		|| state.hasPieceOnStand<KNIGHT>(attacker)
		|| state.hasEffectByPtypeStrict<KNIGHT>(attacker, kp)))
	  return true;
      }
    }
  }
  
  // テストでは出てこないが焦点もあるか?
  while (pieces.any())
  {
    const Piece p=state.getPieceOf(pieces.takeOneBit());
    if (Neighboring8Direct::hasEffectOrAdditional(state, p.ptypeO(), p.position(), king)
	|| Neighboring8::isNeighboring8(p.position(), king))
      continue;		// i.e., need analyses
    if (state.selectLong(p.position(), attacker).any()) // todo: refinement
      continue;
    if (info.liberty() == 0) {
      int i=0;
      for (; i<2; ++i) {
	const Position kp = knight_position[i];
	const Piece kpp = state.getPieceAt(kp);
	if (kpp.isEdge() || state.hasEffectNotBy(defender, p, kp))
	  continue;
	if (p.position() == kp
	    && state.hasPieceOnStand<KNIGHT>(attacker))
	  break;
	if (state.countEffect(defender, kp) == 1)
	  if ((kpp.canMoveOn(attacker)
	       && state.hasEffectByPtypeStrict<KNIGHT>(attacker, kp))
	      || (kpp.isEmpty()
		  && state.hasPieceOnStand<KNIGHT>(attacker)))
	    break;
      }
      if (i<2)
	continue;
    }
    // now we have safe takeback
    return false;
  }
  return true;
}

bool osl::checkmate::
CheckmateIfCapture::effectiveAttack(NumEffectState& state, Move move, int depth)
{
  assert(move.player() == state.getTurn());
  CallDefense defense = { &state, depth, false };
  ApplyMoveOfTurn::doUndoMove(state, move, defense);
#ifdef OSL_DEBUG
  if (defense.result && ! effectiveAttackCandidate0(state, move))
    std::cerr << state << move << "\n", assert(0);
#endif
  return defense.result;
}

bool osl::checkmate::
CheckmateIfCapture::cannotCapture(NumEffectState& state, 
				  Position last_to, int depth)
{
  if (state.inCheck(alt(state.getTurn())))
    return false;		// 前の手が自殺

  using namespace move_generator;
  using namespace move_action;
  MoveVector moves;		// may contain unsafe move
  GenerateCapture::generate(state, last_to, moves);

  if (moves.empty())
    return false;

  FixedDepthSearcher searcher(state);
  const Position king = state.getKingPosition(state.getTurn());
  for (MoveVector::const_iterator p=moves.begin(); p!=moves.end(); ++p)
  {
    if (state.inCheck()) {
      if (state.countEffect(alt(state.getTurn()), king) > 1
	  || ! state.hasEffectByPiece(state.getPieceOnBoard(last_to), king))
	if (p->ptype() != KING)
	  continue;
    }
    const bool checkmate
      = searcher.hasEscapeByMoveOfTurn(*p, depth).isCheckmateSuccess();
    if (! checkmate)
      return false;
  }

  return true;
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
