/* timeKeeper.h
 */
#ifndef GAME_PLAYING_TIMEKEEPER_H
#define GAME_PLAYING_TIMEKEEPER_H

#include "osl/player.h"
#include <boost/scoped_ptr.hpp>
namespace osl
{
  namespace game_playing
  {
    class TimeKeeper
    {
      class Stack;
      boost::scoped_ptr<Stack> seconds;
    public:
      TimeKeeper();
      TimeKeeper(int black_time, int white_time);
      ~TimeKeeper();

      void reset(int black_time, int white_time);

      void pushMove(Player, int seconds);
      void popMove();
      int timeLeft(Player) const;
      int timeElapsed(Player) const;
      int timeLimit(Player) const;
    };
  } // namespace game_playing
} // namespace osl

#endif /* GAME_PLAYING_TIMEKEEPER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
