package com.jamonapi;

import java.util.Date;

import com.jamonapi.utils.ToArray;

/** Class used to add the label, value and time invoked for the associated monitor.  Used in the 
 * jamonBufferListener class.   
 * 
 * @author steve souza
 *
 */
public final class JAMonDetailValue implements ToArray {
	private final String label;  // monitor name
	private final double value; // monitors lastValue
	private final long time;  // invocation time
	private final double active;
	private Object[] row;
	
	static JAMonDetailValue NULL_VALUE=new JAMonDetailValue("Null JAMonDetails Object",0,0,0);
	
	
	public JAMonDetailValue(String label,double value, double active, long time) {
		this.label=label;
		this.value=value;
		this.active=active;
		this.time=time;
	}

	/** Returns label, value, time as an Object[] of 3 values. */
	public Object[] toArray() {
		if (row==null)
		 row = new Object[]{label,new Double(value), new Double(active), new Date(time)};
		
		return row;
	}

}
