/* This file is auto-generated from "request.xml" by the typemaker
   tool of Gwenhywfar. 
   Do not edit this file -- all changes will be lost! */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "request_p.h"
#include <gwenhywfar/misc.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/debug.h>
#include <assert.h>
#include <stdlib.h>
#include <strings.h>


GWEN_INHERIT_FUNCTIONS(GWEN_IPC_REQUEST)
GWEN_LIST_FUNCTIONS(GWEN_IPC_REQUEST, GWEN_IpcRequest)
GWEN_LIST2_FUNCTIONS(GWEN_IPC_REQUEST, GWEN_IpcRequest)


GWEN_IPC_REQUEST_STATUS GWEN_IpcRequest_Status_fromString(const char *s) {
  if (s) {
    if (strcasecmp(s, "new")==0)
      return GWEN_IpcRequest_StatusNew;
    else if (strcasecmp(s, "sent")==0)
      return GWEN_IpcRequest_StatusSent;
    else if (strcasecmp(s, "partial")==0)
      return GWEN_IpcRequest_StatusPartial;
    else if (strcasecmp(s, "answered")==0)
      return GWEN_IpcRequest_StatusAnswered;
    else if (strcasecmp(s, "finished")==0)
      return GWEN_IpcRequest_StatusFinished;
  }
  return GWEN_IpcRequest_StatusUnknown;
}


const char *GWEN_IpcRequest_Status_toString(GWEN_IPC_REQUEST_STATUS v) {
  switch(v) {
    case GWEN_IpcRequest_StatusNew:
      return "new";

    case GWEN_IpcRequest_StatusSent:
      return "sent";

    case GWEN_IpcRequest_StatusPartial:
      return "partial";

    case GWEN_IpcRequest_StatusAnswered:
      return "answered";

    case GWEN_IpcRequest_StatusFinished:
      return "finished";

    default:
      return "unknown";
  } /* switch */
} 


GWEN_IPC_REQUEST *GWEN_IpcRequest_new() {
  GWEN_IPC_REQUEST *st;

  GWEN_NEW_OBJECT(GWEN_IPC_REQUEST, st)
  st->_usage=1;
  GWEN_INHERIT_INIT(GWEN_IPC_REQUEST, st)
  GWEN_LIST_INIT(GWEN_IPC_REQUEST, st)
  st->subRequests=GWEN_IpcRequest_List_new();
  return st;
}


void GWEN_IpcRequest_free(GWEN_IPC_REQUEST *st) {
  if (st) {
    assert(st->_usage);
    if (--(st->_usage)==0) {
  GWEN_INHERIT_FINI(GWEN_IPC_REQUEST, st)
  GWEN_LIST_FINI(GWEN_IPC_REQUEST, st)
  GWEN_FREE_OBJECT(st);
    }
  }

}


GWEN_IPC_REQUEST *GWEN_IpcRequest_dup(const GWEN_IPC_REQUEST *d) {
  GWEN_IPC_REQUEST *st;

  assert(d);
  st=GWEN_IpcRequest_new();
  st->id=d->id;
  if (d->name)
    st->name=strdup(d->name);
  st->ipcId=d->ipcId;
  if (d->expires)
    st->expires=GWEN_Time_dup(d->expires);
  if (d->subRequests)
    st->subRequests=GWEN_IpcRequest_List_dup(d->subRequests);
  st->status=d->status;
  return st;
}


int GWEN_IpcRequest_toDb(const GWEN_IPC_REQUEST *st, GWEN_DB_NODE *db) {
  assert(st);
  assert(db);
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "id", st->id))
    return -1;
  if (st->name)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "name", st->name))
      return -1;
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "ipcId", st->ipcId))
    return -1;
  if (st->expires)
    if (GWEN_Time_toDb(st->expires, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "expires")))
      return -1;
  if (st->subRequests)
  if (1) {
    GWEN_DB_NODE *dbT;
    GWEN_IPC_REQUEST *e;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_CREATE_GROUP, "subRequests");
    assert(dbT);
    e=GWEN_IpcRequest_List_First(st->subRequests);
    while(e) {
      if (GWEN_IpcRequest_toDb(e, GWEN_DB_GetGroup(dbT, GWEN_PATH_FLAGS_CREATE_GROUP, "element")))
        return -1;
      e=GWEN_IpcRequest_List_Next(e);
    } /* while */
  } /* if (1) */
  if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "status", GWEN_IpcRequest_Status_toString(st->status))) 
    return -1;
  return 0;
}


GWEN_IPC_REQUEST *GWEN_IpcRequest_fromDb(GWEN_DB_NODE *db) {
GWEN_IPC_REQUEST *st;

  assert(db);
  st=GWEN_IpcRequest_new();
  GWEN_IpcRequest_SetId(st, GWEN_DB_GetIntValue(db, "id", 0, 0));
  GWEN_IpcRequest_SetName(st, GWEN_DB_GetCharValue(db, "name", 0, 0));
  GWEN_IpcRequest_SetIpcId(st, GWEN_DB_GetIntValue(db, "ipcId", 0, 0));
  if (1) {
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "expires");
    if (dbT) st->expires=GWEN_Time_fromDb(dbT);
  }
  st->subRequests=GWEN_IpcRequest_List_new();
  if (1) {
    GWEN_DB_NODE *dbT;
    GWEN_IPC_REQUEST *e;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "subRequests");
    if (dbT) {
      GWEN_DB_NODE *dbT2;

      dbT2=GWEN_DB_FindFirstGroup(dbT, "element");
      while(dbT2) {
        e=GWEN_IpcRequest_fromDb(dbT2);
        if (!e) {
          DBG_ERROR(0, "Bad element for type \"GWEN_IPC_REQUEST\"");
          if (GWEN_Logger_GetLevel(0)>=GWEN_LoggerLevel_Debug)
            GWEN_DB_Dump(dbT2, stderr, 2);
          GWEN_IpcRequest_free(st);
          return 0;
        }
        GWEN_IpcRequest_List_Add(e, st->subRequests);    dbT2=GWEN_DB_FindNextGroup(dbT2, "element");
      } /* while */
    } /* if (dbT) */
  } /* if (1) */
  GWEN_IpcRequest_SetStatus(st, GWEN_IpcRequest_Status_fromString(GWEN_DB_GetCharValue(db, "status", 0, 0)));
  st->_modified=0;
  return st;
}


uint32_t GWEN_IpcRequest_GetId(const GWEN_IPC_REQUEST *st) {
  assert(st);
  return st->id;
}


void GWEN_IpcRequest_SetId(GWEN_IPC_REQUEST *st, uint32_t d) {
  assert(st);
  st->id=d;
  st->_modified=1;
}




const char *GWEN_IpcRequest_GetName(const GWEN_IPC_REQUEST *st) {
  assert(st);
  return st->name;
}


void GWEN_IpcRequest_SetName(GWEN_IPC_REQUEST *st, const char *d) {
  assert(st);
  if (d)
    st->name=strdup(d);
  else
    st->name=0;
  st->_modified=1;
}




uint32_t GWEN_IpcRequest_GetIpcId(const GWEN_IPC_REQUEST *st) {
  assert(st);
  return st->ipcId;
}


void GWEN_IpcRequest_SetIpcId(GWEN_IPC_REQUEST *st, uint32_t d) {
  assert(st);
  st->ipcId=d;
  st->_modified=1;
}




const GWEN_TIME *GWEN_IpcRequest_GetExpires(const GWEN_IPC_REQUEST *st) {
  assert(st);
  return st->expires;
}


void GWEN_IpcRequest_SetExpires(GWEN_IPC_REQUEST *st, const GWEN_TIME *d) {
  assert(st);
  if (d)
    st->expires=GWEN_Time_dup(d);
  else
    st->expires=0;
  st->_modified=1;
}




GWEN_IPC_REQUEST_LIST *GWEN_IpcRequest_GetSubRequests(const GWEN_IPC_REQUEST *st) {
  assert(st);
  return st->subRequests;
}


void GWEN_IpcRequest_SetSubRequests(GWEN_IPC_REQUEST *st, GWEN_IPC_REQUEST_LIST *d) {
  assert(st);
  if (d) {
    GWEN_IPC_REQUEST *e;

  st->subRequests=GWEN_IpcRequest_List_new();
    e=GWEN_IpcRequest_List_First(d);
    while(e) {
      GWEN_IPC_REQUEST *ne;

      ne=GWEN_IpcRequest_dup(e);
      assert(ne);
      GWEN_IpcRequest_List_Add(ne, st->subRequests);
      e=GWEN_IpcRequest_List_Next(e);
    } /* while (e) */
  } /* if LIST */
  else
    st->subRequests=0;
  st->_modified=1;
}




GWEN_IPC_REQUEST_STATUS GWEN_IpcRequest_GetStatus(const GWEN_IPC_REQUEST *st) {
  assert(st);
  return st->status;
}


void GWEN_IpcRequest_SetStatus(GWEN_IPC_REQUEST *st, GWEN_IPC_REQUEST_STATUS d) {
  assert(st);
  st->status=d;
  st->_modified=1;
}


GWEN_IPC_REQUEST_WORK_FN GWEN_IpcRequest_GetWorkFn(const GWEN_IPC_REQUEST *st) {
  assert(st);
  return st->workFn;
}


void GWEN_IpcRequest_SetWorkFn(GWEN_IPC_REQUEST *st, GWEN_IPC_REQUEST_WORK_FN d) {
  assert(st);
  st->workFn=d;
}


int GWEN_IpcRequest_WorkFn(GWEN_IPC_REQUEST *st) {
  assert(st);
  if (st->workFn)
    return st->workFn(st);
return 1;
}




int GWEN_IpcRequest_IsModified(const GWEN_IPC_REQUEST *st) {
  assert(st);
  return st->_modified;
}


void GWEN_IpcRequest_SetModified(GWEN_IPC_REQUEST *st, int i) {
  assert(st);
  st->_modified=i;
}


void GWEN_IpcRequest_Attach(GWEN_IPC_REQUEST *st) {
  assert(st);
  st->_usage++;
}
GWEN_IPC_REQUEST *GWEN_IpcRequest_List2__freeAll_cb(GWEN_IPC_REQUEST *st, void *user_data) {
  GWEN_IpcRequest_free(st);
return 0;
}


void GWEN_IpcRequest_List2_freeAll(GWEN_IPC_REQUEST_LIST2 *stl) {
  if (stl) {
    GWEN_IpcRequest_List2_ForEach(stl, GWEN_IpcRequest_List2__freeAll_cb, 0);
    GWEN_IpcRequest_List2_free(stl); 
  }
}




GWEN_IPC_REQUEST_LIST *GWEN_IpcRequest_List_dup(const GWEN_IPC_REQUEST_LIST *stl) {
  if (stl) {
    GWEN_IPC_REQUEST_LIST *nl;
    GWEN_IPC_REQUEST *e;

    nl=GWEN_IpcRequest_List_new();
    e=GWEN_IpcRequest_List_First(stl);
    while(e) {
      GWEN_IPC_REQUEST *ne;

      ne=GWEN_IpcRequest_dup(e);
      assert(ne);
      GWEN_IpcRequest_List_Add(ne, nl);
      e=GWEN_IpcRequest_List_Next(e);
    } /* while (e) */
    return nl;
  }
  else
    return 0;
}



