/*****************************************************************************************************************************************
 gtkol-popup.c

 Simple gtkol popup menu sample. The popup menu deletes the control that sended the poup event.
*****************************************************************************************************************************************/

#include "capplication.h"

//----------------------------------------------------------------------------------------------------------------------------------------
// CCloseButtonListener
//----------------------------------------------------------------------------------------------------------------------------------------
class CCloseButtonListener : public CButtonListener
{
	// called when the button is clicked
	virtual void OnClick (CObject *inSender)
	{
		// in our sample, the button is handled in a vboxlayout that is also handled in the main form : Form->Layout->Button; we 
		// could call ((CForm*)(((CComponent*)inSender)->GetOwner()->GetOwner()))->Close() to get the main form this listener is 
		// supposed to close but we can get it indirectly by specifying the expected desired owner type as follow :
		static_cast <CForm *> (static_cast <CButton *> (inSender) -> GetOwner (__metaclass(CForm))) -> Close ();
	}
};

//----------------------------------------------------------------------------------------------------------------------------------------
// CFileExitMenuItemListener
//----------------------------------------------------------------------------------------------------------------------------------------
class CFileExitMenuItemListener : public CMenuItemListener
{
	// called when the menu is clicked 
	virtual void OnClick (CObject *inSender)
	{
		// in our sample, the exit menu item is handled in a file menu item that is handled in a menubar that is handled in a 
		// vboxlayout that is also handled in the main form : Form->Layout->MenuBar->File->Quit; we could call 
		// ((CForm*)(((CComponent*)inSender)->GetOwner()->GetOwner()->GetOwner()->GetOwner()))->Close() to get the main form this 
		// listener is supposed to close but we can get it indirectly by specifying the expected desired owner type as follow :
		static_cast <CForm *> (static_cast <CMenuItem *> (inSender) -> GetOwner (__metaclass(CForm))) -> Close ();
	}
};

//----------------------------------------------------------------------------------------------------------------------------------------
// CMenuItemDeleteListener
//----------------------------------------------------------------------------------------------------------------------------------------
class CMenuItemDeleteListener : public CMenuItemListener
{
	// called when the menu item is clicked
	virtual void OnClick (CObject *inSender)
	{
		// get the menu item
		CMenuItem *inMenuItem = static_cast <CMenuItem *> (inSender);

		// get the menu item popup menu owner
		CMenuPopup *inMenuPopup = static_cast <CMenuPopup*> (inMenuItem -> GetOwner (__metaclass(CMenuPopup)));

		// get the control that sended the popup event
		CControl *inPopupSender = inMenuPopup -> GetPopupSender ();

		// delete the sender instance...
		delete inPopupSender;
	}
};

//----------------------------------------------------------------------------------------------------------------------------------------
// demonstration entry point
//----------------------------------------------------------------------------------------------------------------------------------------
int main (int argc, char **argv)
{
	// be proper, catch any potential exception
	try
	{
		// declare a gtkol application instance giving it the command line arguments; those arguments are used to 
		// initialize the gtk library (there won't be any initilization if you do not specify those arguments).
		CApplication Application (argc, argv);

		// instanciate a main form and set its caption
		CForm *MainForm = new CForm (&Application);
		MainForm -> SetCaption (CString("Gtkol Popup menu"));
		MainForm -> SetBounds  (TBounds (150, 150, 210, 80));

		// instanciate a popup menu on the main form so that any child of the whole form may generate the defined popup menu
		// and instanciate a menu item whose purpose is defined by the associated listener
		CMenuPopup *MenuPopup = new CMenuPopup (MainForm);
		CMenuItem  *Delete    = new CMenuItem  (MenuPopup, CString("_Delete"), _HKNone_, new CMenuItemDeleteListener());

		// the form is a GtkBin widget i.e. it can contain only one child widget wich is a little bit restrictive; so
		// instanciate a vertical box layout so that we can put more than one child in our form and set some properties
		CVBoxLayout *VBoxLayout = new CVBoxLayout (MainForm);
		VBoxLayout -> SetHomogeneous (false);
		VBoxLayout -> SetSpacing (1);
		VBoxLayout -> SetBoxPack (BOXPACK_START, false, false, 0);

		// instanciate the menu components : VBoxLayout->MenuBar->File->Quit; the quit menu item is associated to an
		// accelerator (ctrl+q see cmenu.h) and our specific menu item listener
		CMenuBar  *MenuBar = new CMenuBar  (VBoxLayout);
		CMenuItem *File    = new CMenuItem (MenuBar, CString("_File"));
		CMenuItem *Exit    = new CMenuItem (File, CString("_Quit"), _HKQuit_, new CFileExitMenuItemListener());
		new CMenuItem (File, CString("_Save"), _HKSave_);

		// reset some properties on the global vertical layout
		VBoxLayout -> SetBoxPack (BOXPACK_START, true, true, 0);

		// instanciate a button whose purpose is to close the form when clicked, associate it to our specific listener to
		// do so and set its caption
		CButton *Button = new CButton (VBoxLayout, new CCloseButtonListener());
		Button -> SetCaption (CString("_Close"));

		// show our job (the form is the only gtkol widget that is not shown by default)
		MainForm -> Show ();

		// launch the application event queue dispatching
		Application.Run ();
	}
	// an exception occurred, just print it and return
	catch (CException *e)
	{
		fprintf (stderr, "%s\n", e->GetMessage().Get());
		return -1;
	}

	// ok
	return 0;
}

