/*******************************************************************************************************************************************
 cseparator.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CSeparator

 The CSeparator widget is an abstract class, used only for deriving the subclasses CHSeparator and CVSeparator. Those classes just act as
 logical separators for the gui.
*******************************************************************************************************************************************/

#ifndef __CSEPARATOR_H__
#define __CSEPARATOR_H__

#include "ccontainer.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// CSeparator class
//------------------------------------------------------------------------------------------------------------------------------------------
class CSeparator : public CWidget
{
	// instanciation section
	public :

		CSeparator			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CSeparator		() =0;

	// widget gtkol requests protected handling
	protected :

		// separator widget initialization
		virtual void			PerformWidgetInitialize		();

	// CComponent redefinition
	public :

		// expected owner types : CContainer instances...
		virtual CMetaClasses		OwnerMustBe			() const;

		// onwer affectation, this version of the function devides its siblings radio components into logical groups if any
		virtual Bool			SetOwner			(CComponent *inOwner, const SInt16 inIndex=-1);

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('spar', CSeparator, CWidget);

#endif
