/*******************************************************************************************************************************************
 cbutton.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl		         |
	        |--CWidget		         |--CWidgetListener
		   |--CContainer	   	    |
		      |--CButton		    |--CButtonListener

 Standard pression button definition.
*******************************************************************************************************************************************/

#ifndef __CBUTTON_H__
#define __CBUTTON_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// button xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cbutton caption="string">
//    ...
// </cbutton>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_BUTTON_ELEMENT	("cbutton");
static CString XML_BUTTON_ATTR_CAPTION	("caption");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CButtonListener class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CButtonListener : public CWidgetListener
{
	// instanciation section
	public :

		CButtonListener			();
		virtual ~CButtonListener	() =0;

	// specific listener functions
	public :

		// called when inSender button is clicked
		virtual void			OnClick			(CObject *inSender)	{ }

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_GENERIC_METACLASS ('_btn', CButtonListener, CWidgetListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CButton class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CButton : public CContainer
{
	// instanciation section
	public :

		CButton				(CContainer *inOwner=NULL, const CButtonListener *inListener=NULL);
		virtual ~CButton		();

	// protected instanciation process definition
	protected :

		// specific gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

		// specific container handling
		virtual void			PerformContainerAdd		(CWidget *inChild);
		virtual void			PerformContainerRemove		(CWidget *inChild);

	// CObject redefinition
	protected :

		// expected CButtonListener
		virtual const CMetaClass *	ListenerMustBe			() const;

	// CComponent redefinition
	public :

		// expected owner type : __metaclasses(CContainer)
		virtual CMetaClasses		OwnerMustBe			() const;

	// CButton specific functions
	public :

		// button caption (underline char to specify following char shortcut)
		virtual void			SetCaption			(const CString &inCaption);
		virtual CString			GetCaption			() const;

		// OnClick event sender
		virtual void			Click				();

	// CSerialized redefinition
	public :

		// CButton xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;
	
	// protected attributes
	protected :

		// static -> dynamic event resolution
		static void 			OnClick				(GtkButton *, gpointer);

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_DYNAMIC_METACLASS ('bttn', CButton, CContainer);

#endif
