#!/bin/bash

echo "Started build: `date`"

_ARGS="$*"

# Modify these settings for your personal environment,
# although it is recommended that you use these paths.
_MEM_SIZE=128m
#JDK_11=/usr/java/jdk1.1
#JDK_12=/usr/java/jdk1.2
JDK_13=/usr/java/jdk1.3
JDK_14=/usr/java/jdk1.4


#JDK_11_maxmem=-mx$_MEM_SIZE
#JDK_12_maxmem=-Xmx$_MEM_SIZE
JDK_13_maxmem=-Xmx$_MEM_SIZE
JDK_14_maxmem=-Xmx$_MEM_SIZE


# Set to JDK 1.4 so that all projects will be cleaned up
export JAVA_HOME=$JDK_14
export ANT_OPTS=$JDK_14_maxmem
./make.sh clean $_ARGS || exit 1

# Sun doesn't support 1.1 on Linux, so this is an optional step
# but cygwin can also be used!
#if [ -f $JDK_11/bin/java -o -f $JDK_11/bin/java.exe ]; then
#  echo "======================================================================="
#  echo "======================================================================="
#  echo "=====  JDK 1.1  ====="
#  echo "======================================================================="
#  echo "======================================================================="
#  export JAVA_HOME=$JDK_11
#  export ANT_OPTS=$JDK_11_maxmem
#  ./make.sh main || exit 1
#else
#  echo "---- Skipping JDK 1.1 ----"
#fi

if [ -f $JDK_12/bin/java -o -f $JDK_12/bin/java.exe ]; then
  if [ $(uname) != Linux ]; then
    # The Linux version of JDK 1.2 doesn't work with the thread queue
    # correctly.
    echo "======================================================================="
    echo "======================================================================="
    echo "=====  JDK 1.2  ====="
    echo "======================================================================="
    echo "======================================================================="
    export JAVA_HOME=$JDK_12
    export ANT_OPTS=$JDK_12_maxmem
    ./make.sh main $_ARGS || exit 1
  fi
fi

if [ -f $JDK_13/bin/java -o -f $JDK_13/bin/java.exe ]; then
  echo "======================================================================="
  echo "======================================================================="
  echo "=====  JDK 1.3  ====="
  echo "======================================================================="
  echo "======================================================================="
  export JAVA_HOME=$JDK_13
  export ANT_OPTS=$JDK_13_maxmem
  ./make.sh main $_ARGS || exit 1
fi

echo "======================================================================="
echo "======================================================================="
echo "=====  JDK 1.4  ====="
echo "======================================================================="
echo "======================================================================="
# Website construction with JDK 1.4 requires correct bootclasspath setup
# to use the GroboUtils' included Xalan and Xerces processors, not the
# included JDK 1.4 ones.  The "make.sh" script does this correctly.
export JAVA_HOME=$JDK_14
export ANT_OPTS=$JDK_14_maxmem
./make.sh deploy $_ARGS || exit 1


echo "Completed build: `date`"
