/**
 * @file person-attr-test.c A simple test for person attributes
 *
 * @Copyright (C) 2005-2006 Christian Hammond <chipx86@chipx86.com>
 * @Copyright (C) 2004 Trent Lloyd  <lathiat@bur.st>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <libgalago/galago.h>
#include <glib.h>
#include <dbus/dbus-glib.h>
#include <stdio.h>
#include <string.h>

int
main(int argc, char *argv[])
{
	GalagoService *service;
	GalagoAccount *account;
	GalagoPerson *person;
	GalagoPresence *presence;
	GalagoStatus *status;

	if (!galago_init("person-attr-test-feed", GALAGO_INIT_FEED))
		exit(1);

	/* Setup our test service */
	service  = galago_create_service("lathiat", "Lathiats Godly Program", 0);
	person   = galago_create_person("dizzy");
	account  = galago_service_create_account(service, person, "lathiat");
	presence = galago_account_create_presence(account);

	status = galago_status_new(GALAGO_STATUS_AVAILABLE, "harass",
							   "Taking harassments", TRUE);

	galago_presence_add_status(presence, status);

	galago_object_set_attr_string(GALAGO_OBJECT(person),
								  "email", "lathiat@bur.st");
	galago_object_set_attr_string(GALAGO_OBJECT(person),
								  "x-godly", "false");

	printf("Properties: (email=lathiat@bur.st)=%s, (x-godly=false)=%s\n",
			galago_object_get_attr_string(GALAGO_OBJECT(person), "email"),
			galago_object_get_attr_string(GALAGO_OBJECT(person), "x-godly"));

	printf("Removing godly\n");

	galago_object_remove_attribute(GALAGO_OBJECT(person), "x-godly");

	printf("Properties: (email=lathiat@bur.st)=%s, (x-godly=NULL)=%s\n",
			galago_object_get_attr_string(GALAGO_OBJECT(person), "email"),
			galago_object_get_attr_string(GALAGO_OBJECT(person), "x-godly"));

	printf("Changing email\n");

	galago_object_set_attr_string(GALAGO_OBJECT(person),
								  "email", "lathiat@sixlabs.org");

	printf("Properties: (email=lathiat@sixlabs.org)=%s, (x-godly=NULL)=%s\n",
			galago_object_get_attr_string(GALAGO_OBJECT(person), "email"),
			galago_object_get_attr_string(GALAGO_OBJECT(person), "x-godly"));

	printf("done.\n");

	return 0;
}
