/* dpapview.c generated by valac 0.12.0, the Vala compiler
 * generated from dpapview.vala, do not modify */

/*   FILE: dpapviewer.vala -- View DPAP data
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 24 November 2010
 *
 * Copyright (c) 2010 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <libdmapsharing/dmap.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DPAP_VIEWER (dpap_viewer_get_type ())
#define DPAP_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DPAP_VIEWER, DPAPViewer))
#define DPAP_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DPAP_VIEWER, DPAPViewerClass))
#define IS_DPAP_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DPAP_VIEWER))
#define IS_DPAP_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DPAP_VIEWER))
#define DPAP_VIEWER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DPAP_VIEWER, DPAPViewerClass))

typedef struct _DPAPViewer DPAPViewer;
typedef struct _DPAPViewerClass DPAPViewerClass;
typedef struct _DPAPViewerPrivate DPAPViewerPrivate;

#define TYPE_VALA_DMAP_DB (vala_dmap_db_get_type ())
#define VALA_DMAP_DB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_DMAP_DB, ValaDMAPDb))
#define VALA_DMAP_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_DMAP_DB, ValaDMAPDbClass))
#define IS_VALA_DMAP_DB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_DMAP_DB))
#define IS_VALA_DMAP_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_DMAP_DB))
#define VALA_DMAP_DB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_DMAP_DB, ValaDMAPDbClass))

typedef struct _ValaDMAPDb ValaDMAPDb;
typedef struct _ValaDMAPDbClass ValaDMAPDbClass;

#define TYPE_VALA_DPAP_RECORD_FACTORY (vala_dpap_record_factory_get_type ())
#define VALA_DPAP_RECORD_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_DPAP_RECORD_FACTORY, ValaDPAPRecordFactory))
#define VALA_DPAP_RECORD_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_DPAP_RECORD_FACTORY, ValaDPAPRecordFactoryClass))
#define IS_VALA_DPAP_RECORD_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_DPAP_RECORD_FACTORY))
#define IS_VALA_DPAP_RECORD_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_DPAP_RECORD_FACTORY))
#define VALA_DPAP_RECORD_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_DPAP_RECORD_FACTORY, ValaDPAPRecordFactoryClass))

typedef struct _ValaDPAPRecordFactory ValaDPAPRecordFactory;
typedef struct _ValaDPAPRecordFactoryClass ValaDPAPRecordFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_VALA_DPAP_RECORD (vala_dpap_record_get_type ())
#define VALA_DPAP_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_DPAP_RECORD, ValaDPAPRecord))
#define VALA_DPAP_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_DPAP_RECORD, ValaDPAPRecordClass))
#define IS_VALA_DPAP_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_DPAP_RECORD))
#define IS_VALA_DPAP_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_DPAP_RECORD))
#define VALA_DPAP_RECORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_DPAP_RECORD, ValaDPAPRecordClass))

typedef struct _ValaDPAPRecord ValaDPAPRecord;
typedef struct _ValaDPAPRecordClass ValaDPAPRecordClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dpap_viewer_unref0(var) ((var == NULL) ? NULL : (var = (dpap_viewer_unref (var), NULL)))
typedef struct _ParamSpecDPAPViewer ParamSpecDPAPViewer;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DPAPViewer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DPAPViewerPrivate * priv;
};

struct _DPAPViewerClass {
	GTypeClass parent_class;
	void (*finalize) (DPAPViewer *self);
};

struct _DPAPViewerPrivate {
	DMAPMdnsBrowser* browser;
	DMAPConnection* connection;
	GtkListStore* liststore;
	ValaDMAPDb* db;
	ValaDPAPRecordFactory* factory;
};

struct _ParamSpecDPAPViewer {
	GParamSpec parent_instance;
};


static gpointer dpap_viewer_parent_class = NULL;

gpointer dpap_viewer_ref (gpointer instance);
void dpap_viewer_unref (gpointer instance);
GParamSpec* param_spec_dpap_viewer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_dpap_viewer (GValue* value, gpointer v_object);
void value_take_dpap_viewer (GValue* value, gpointer v_object);
gpointer value_get_dpap_viewer (const GValue* value);
GType dpap_viewer_get_type (void) G_GNUC_CONST;
GType vala_dmap_db_get_type (void) G_GNUC_CONST;
GType vala_dpap_record_factory_get_type (void) G_GNUC_CONST;
#define DPAP_VIEWER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DPAP_VIEWER, DPAPViewerPrivate))
enum  {
	DPAP_VIEWER_DUMMY_PROPERTY
};
static gboolean dpap_viewer_connected_cb (DPAPViewer* self, DMAPConnection* connection, gboolean _result_, const gchar* reason);
static void _lambda0_ (gconstpointer k, gconstpointer v, DPAPViewer* self);
GType vala_dpap_record_get_type (void) G_GNUC_CONST;
GByteArray* vala_dpap_record_get_thumbnail (ValaDPAPRecord* self);
const gchar* vala_dpap_record_get_filename (ValaDPAPRecord* self);
static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void dpap_viewer_service_added_cb (DPAPViewer* self, DMAPMdnsBrowserService* service);
static gboolean _dpap_viewer_connected_cb_dmap_connection_callback (DMAPConnection* connection, gboolean _result_, const gchar* reason, gpointer self);
DPAPViewer* dpap_viewer_new (GtkBuilder* builder, GError** error);
DPAPViewer* dpap_viewer_construct (GType object_type, GtkBuilder* builder, GError** error);
ValaDMAPDb* vala_dmap_db_new (void);
ValaDMAPDb* vala_dmap_db_construct (GType object_type);
ValaDPAPRecordFactory* vala_dpap_record_factory_new (void);
ValaDPAPRecordFactory* vala_dpap_record_factory_construct (GType object_type);
static void _dpap_viewer_service_added_cb_dmap_mdns_browser_service_added (DMAPMdnsBrowser* _sender, void* service, gpointer self);
static void dpap_viewer_finalize (DPAPViewer* obj);
gint _vala_main (gchar** args, int args_length1);


static void _lambda0_ (gconstpointer k, gconstpointer v, DPAPViewer* self) {
	GdkPixbuf* pixbuf;
	GByteArray* _tmp0_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp6_ = {0};
	const gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	pixbuf = NULL;
	_tmp0_ = vala_dpap_record_get_thumbnail (VALA_DPAP_RECORD (v));
	if (_tmp0_ != NULL) {
		gchar* path = NULL;
		gchar* _tmp1_ = NULL;
		gint _tmp2_;
		gint fd;
		GByteArray* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_;
		_tmp2_ = g_file_open_tmp ("dpapview.XXXXXX", &_tmp1_, &_inner_error_);
		_g_free0 (path);
		path = _tmp1_;
		fd = _tmp2_;
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = vala_dpap_record_get_thumbnail (VALA_DPAP_RECORD (v));
		g_file_set_contents (path, (const char*) _tmp3_->data, (size_t) ((gint) _tmp3_->len), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		close (fd);
		_tmp4_ = gdk_pixbuf_new_from_file (path, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp5_;
		g_unlink (path);
		_g_free0 (path);
	}
	gtk_list_store_append (self->priv->liststore, &_tmp6_);
	iter = _tmp6_;
	_tmp7_ = vala_dpap_record_get_filename (VALA_DPAP_RECORD (v));
	gtk_list_store_set (self->priv->liststore, &iter, 0, pixbuf, 1, _tmp7_, -1);
	_g_object_unref0 (pixbuf);
}


static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda0_ (key, value, self);
}


static gboolean dpap_viewer_connected_cb (DPAPViewer* self, DMAPConnection* connection, gboolean _result_, const gchar* reason) {
	gboolean result = FALSE;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (connection != NULL, FALSE);
	_tmp0_ = dmap_db_count ((DMAPDb*) self->priv->db);
	g_debug ("dpapview.vala:31: %lld entries\n", _tmp0_);
	dmap_db_foreach ((DMAPDb*) self->priv->db, __lambda0__gh_func, self);
	result = TRUE;
	return result;
}


static gboolean _dpap_viewer_connected_cb_dmap_connection_callback (DMAPConnection* connection, gboolean _result_, const gchar* reason, gpointer self) {
	gboolean result;
	result = dpap_viewer_connected_cb (self, connection, _result_, reason);
	return result;
}


static void dpap_viewer_service_added_cb (DPAPViewer* self, DMAPMdnsBrowserService* service) {
	DPAPConnection* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dpap_connection_new (service->service_name, service->host, service->port, (DMAPDb*) self->priv->db, (DMAPRecordFactory*) self->priv->factory);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = DMAP_CONNECTION (_tmp0_);
	dmap_connection_connect (self->priv->connection, _dpap_viewer_connected_cb_dmap_connection_callback, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _dpap_viewer_service_added_cb_dmap_mdns_browser_service_added (DMAPMdnsBrowser* _sender, void* service, gpointer self) {
	dpap_viewer_service_added_cb (self, service);
}


DPAPViewer* dpap_viewer_construct (GType object_type, GtkBuilder* builder, GError** error) {
	DPAPViewer* self = NULL;
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* widget;
	GObject* _tmp3_ = NULL;
	GObject* _tmp4_;
	GtkIconView* _tmp5_;
	GtkIconView* iconview;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_;
	GtkListStore* _tmp8_;
	ValaDMAPDb* _tmp9_ = NULL;
	ValaDPAPRecordFactory* _tmp10_ = NULL;
	DMAPMdnsBrowser* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (builder != NULL, NULL);
	self = (DPAPViewer*) g_type_create_instance (object_type);
	gtk_builder_connect_signals (builder, self);
	_tmp0_ = gtk_builder_get_object (builder, "window");
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp1_) ? ((GtkWidget*) _tmp1_) : NULL);
	widget = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "iconview");
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (GTK_IS_ICON_VIEW (_tmp4_) ? ((GtkIconView*) _tmp4_) : NULL);
	iconview = _tmp5_;
	_tmp6_ = gtk_builder_get_object (builder, "liststore");
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (GTK_IS_LIST_STORE (_tmp7_) ? ((GtkListStore*) _tmp7_) : NULL);
	_g_object_unref0 (self->priv->liststore);
	self->priv->liststore = _tmp8_;
	_tmp9_ = vala_dmap_db_new ();
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp9_;
	_tmp10_ = vala_dpap_record_factory_new ();
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp10_;
	gtk_icon_view_set_pixbuf_column (iconview, 0);
	gtk_icon_view_set_text_column (iconview, 1);
	gtk_widget_show_all (widget);
	_tmp11_ = dmap_mdns_browser_new (DMAP_MDNS_BROWSER_SERVICE_TYPE_DPAP);
	_g_object_unref0 (self->priv->browser);
	self->priv->browser = _tmp11_;
	g_signal_connect (self->priv->browser, "service-added", (GCallback) _dpap_viewer_service_added_cb_dmap_mdns_browser_service_added, self);
	dmap_mdns_browser_start (self->priv->browser, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (iconview);
		_g_object_unref0 (widget);
		_dpap_viewer_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (iconview);
	_g_object_unref0 (widget);
	return self;
}


DPAPViewer* dpap_viewer_new (GtkBuilder* builder, GError** error) {
	return dpap_viewer_construct (TYPE_DPAP_VIEWER, builder, error);
}


static void value_dpap_viewer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_dpap_viewer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dpap_viewer_unref (value->data[0].v_pointer);
	}
}


static void value_dpap_viewer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dpap_viewer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_dpap_viewer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_dpap_viewer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DPAPViewer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dpap_viewer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_dpap_viewer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DPAPViewer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dpap_viewer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_dpap_viewer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDPAPViewer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DPAP_VIEWER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_dpap_viewer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DPAP_VIEWER), NULL);
	return value->data[0].v_pointer;
}


void value_set_dpap_viewer (GValue* value, gpointer v_object) {
	DPAPViewer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DPAP_VIEWER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DPAP_VIEWER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dpap_viewer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dpap_viewer_unref (old);
	}
}


void value_take_dpap_viewer (GValue* value, gpointer v_object) {
	DPAPViewer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DPAP_VIEWER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DPAP_VIEWER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dpap_viewer_unref (old);
	}
}


static void dpap_viewer_class_init (DPAPViewerClass * klass) {
	dpap_viewer_parent_class = g_type_class_peek_parent (klass);
	DPAP_VIEWER_CLASS (klass)->finalize = dpap_viewer_finalize;
	g_type_class_add_private (klass, sizeof (DPAPViewerPrivate));
}


static void dpap_viewer_instance_init (DPAPViewer * self) {
	self->priv = DPAP_VIEWER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void dpap_viewer_finalize (DPAPViewer* obj) {
	DPAPViewer * self;
	self = DPAP_VIEWER (obj);
	_g_object_unref0 (self->priv->browser);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->liststore);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
}


GType dpap_viewer_get_type (void) {
	static volatile gsize dpap_viewer_type_id__volatile = 0;
	if (g_once_init_enter (&dpap_viewer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_dpap_viewer_init, value_dpap_viewer_free_value, value_dpap_viewer_copy_value, value_dpap_viewer_peek_pointer, "p", value_dpap_viewer_collect_value, "p", value_dpap_viewer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DPAPViewerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dpap_viewer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DPAPViewer), 0, (GInstanceInitFunc) dpap_viewer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dpap_viewer_type_id;
		dpap_viewer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DPAPViewer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dpap_viewer_type_id__volatile, dpap_viewer_type_id);
	}
	return dpap_viewer_type_id__volatile;
}


gpointer dpap_viewer_ref (gpointer instance) {
	DPAPViewer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dpap_viewer_unref (gpointer instance) {
	DPAPViewer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DPAP_VIEWER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* builder;
	DPAPViewer* _tmp1_ = NULL;
	DPAPViewer* dpapviewer;
	GError * _inner_error_ = NULL;
	gtk_init (&args_length1, &args);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	gtk_builder_add_from_file (builder, "tests/dpapview.ui", &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		goto __catch0_g_error;
	}
	_tmp1_ = dpap_viewer_new (builder, &_inner_error_);
	dpapviewer = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		goto __catch0_g_error;
	}
	gtk_main ();
	_dpap_viewer_unref0 (dpapviewer);
	_g_object_unref0 (builder);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Error: %s\n", e->message);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



