/*
 * compat defines
 *
 * Copyright 1993 by the Antaire Corporation
 *
 * $Id: compat.h,v 1.5 1993/09/29 22:19:34 gray Exp $
 */

#ifndef __COMPAT_H__
#define __COMPAT_H__

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/*
 * find CH in STR by searching backwards through the string
 */
#if HAVE_RINDEX == 0
EXPORT	char	*rindex(const char * str, int ch);
#endif

/*
 * alloc space for PTR (with NULL) and copy it to new space, user must free
 */
#if HAVE_STRDUP == 0
IMPORT	char	*strdup(const char * ptr);
#endif

/*
 * compare at most LEN chars in STR1 and STR2 and return -1,0,1 or STR1 - STR2
 */
#if HAVE_STRNCMP == 0
IMPORT	char	*strncmp(char * str1, const char * str2, const int len);
#endif

/*
 * find STR2 inside STR1, returns NULL if not found
 */
#if HAVE_STRSTR == 0
IMPORT	char	*strstr(const char * str1, const char * str2);
#endif

/*
 * get the next token from STR (pass in NULL on the 2nd, 3rd, etc. calls),
 * tokens are a list of characters deliminated by a character from DELIM.
 * writes null into STR to end token.
 */
#if HAVE_STRTOK == 0
EXPORT	char	*strtok(char * str, char * delim)
#endif

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __COMPAT_H__ */
