/*
 * Test of sys/utsname.h
 */
#include "hdrchk.h"
#include <stdio.h>
#include <sys/types.h>
#define _LSB_DEFAULT_ARCH 1
#include "sys/utsname.h"



#ifdef TET_TEST
void sys_utsname_h()
{
#else
int sys_utsname_h()
{
#endif

int cnt=0;

int pcnt=0;
#ifdef TET_TEST
Msg("Checking data structures in sys/utsname.h\n");
#endif

printf("Checking data structures in sys/utsname.h\n");
#if _LSB_DEFAULT_ARCH
#ifdef SYS_NMLN
	CompareConstant(SYS_NMLN,65,1728,architecture,2.0,NULL)
#else
Msg( "Error: Constant not found: SYS_NMLN\n");
cnt++;
#endif

#endif

#if defined __i386__
CheckTypeSize(struct utsname,390, 7013, 2, 1.2, NULL, 0, NULL)
CheckMemberSize(struct utsname,nodename,65,2,30178)
CheckOffset(struct utsname,nodename,65,2,30178)
CheckMemberSize(struct utsname,release,65,2,30179)
CheckOffset(struct utsname,release,130,2,30179)
CheckMemberSize(struct utsname,version,65,2,30180)
CheckOffset(struct utsname,version,195,2,30180)
CheckMemberSize(struct utsname,machine,65,2,30181)
CheckOffset(struct utsname,machine,260,2,30181)
CheckMemberSize(struct utsname,domainname,65,2,34411)
CheckOffset(struct utsname,domainname,325,2,34411)
#elif defined __ia64__
CheckTypeSize(struct utsname,390, 7013, 3, 1.3, NULL, 0, NULL)
CheckMemberSize(struct utsname,nodename,65,3,30178)
CheckOffset(struct utsname,nodename,65,3,30178)
CheckMemberSize(struct utsname,release,65,3,30179)
CheckOffset(struct utsname,release,130,3,30179)
CheckMemberSize(struct utsname,version,65,3,30180)
CheckOffset(struct utsname,version,195,3,30180)
CheckMemberSize(struct utsname,machine,65,3,30181)
CheckOffset(struct utsname,machine,260,3,30181)
CheckMemberSize(struct utsname,domainname,65,3,34411)
CheckOffset(struct utsname,domainname,325,3,34411)
#elif defined __powerpc__ && !defined __powerpc64__
CheckTypeSize(struct utsname,390, 7013, 6, 1.2, NULL, 0, NULL)
CheckMemberSize(struct utsname,nodename,65,6,30178)
CheckOffset(struct utsname,nodename,65,6,30178)
CheckMemberSize(struct utsname,release,65,6,30179)
CheckOffset(struct utsname,release,130,6,30179)
CheckMemberSize(struct utsname,version,65,6,30180)
CheckOffset(struct utsname,version,195,6,30180)
CheckMemberSize(struct utsname,machine,65,6,30181)
CheckOffset(struct utsname,machine,260,6,30181)
CheckMemberSize(struct utsname,domainname,65,6,34411)
CheckOffset(struct utsname,domainname,325,6,34411)
#elif defined __s390__ && !defined __s390x__
CheckTypeSize(struct utsname,390, 7013, 10, 1.3, NULL, 0, NULL)
CheckMemberSize(struct utsname,nodename,65,10,30178)
CheckOffset(struct utsname,nodename,65,10,30178)
CheckMemberSize(struct utsname,release,65,10,30179)
CheckOffset(struct utsname,release,130,10,30179)
CheckMemberSize(struct utsname,version,65,10,30180)
CheckOffset(struct utsname,version,195,10,30180)
CheckMemberSize(struct utsname,machine,65,10,30181)
CheckOffset(struct utsname,machine,260,10,30181)
CheckMemberSize(struct utsname,domainname,65,10,34411)
CheckOffset(struct utsname,domainname,325,10,34411)
#elif defined __powerpc64__
CheckTypeSize(struct utsname,390, 7013, 9, 2.0, NULL, 0, NULL)
CheckMemberSize(struct utsname,nodename,65,9,30178)
CheckOffset(struct utsname,nodename,65,9,30178)
CheckMemberSize(struct utsname,release,65,9,30179)
CheckOffset(struct utsname,release,130,9,30179)
CheckMemberSize(struct utsname,version,65,9,30180)
CheckOffset(struct utsname,version,195,9,30180)
CheckMemberSize(struct utsname,machine,65,9,30181)
CheckOffset(struct utsname,machine,260,9,30181)
CheckMemberSize(struct utsname,domainname,65,9,34411)
CheckOffset(struct utsname,domainname,325,9,34411)
#elif defined __s390x__
CheckTypeSize(struct utsname,390, 7013, 12, 1.3, NULL, 0, NULL)
CheckMemberSize(struct utsname,nodename,65,12,30178)
CheckOffset(struct utsname,nodename,65,12,30178)
CheckMemberSize(struct utsname,release,65,12,30179)
CheckOffset(struct utsname,release,130,12,30179)
CheckMemberSize(struct utsname,version,65,12,30180)
CheckOffset(struct utsname,version,195,12,30180)
CheckMemberSize(struct utsname,machine,65,12,30181)
CheckOffset(struct utsname,machine,260,12,30181)
CheckMemberSize(struct utsname,domainname,65,12,34411)
CheckOffset(struct utsname,domainname,325,12,34411)
#elif defined __x86_64__
CheckTypeSize(struct utsname,390, 7013, 11, 2.0, NULL, 0, NULL)
CheckMemberSize(struct utsname,nodename,65,11,30178)
CheckOffset(struct utsname,nodename,65,11,30178)
CheckMemberSize(struct utsname,release,65,11,30179)
CheckOffset(struct utsname,release,130,11,30179)
CheckMemberSize(struct utsname,version,65,11,30180)
CheckOffset(struct utsname,version,195,11,30180)
CheckMemberSize(struct utsname,machine,65,11,30181)
CheckOffset(struct utsname,machine,260,11,30181)
CheckMemberSize(struct utsname,domainname,65,11,34411)
CheckOffset(struct utsname,domainname,325,11,34411)
#else
Msg("Find size of utsname (7013)\n");
Msg("REPLACE INTO ArchType VALUES (%d,%d,%d,'""2.0""',NULL,0, NULL);\n",architecture,7013,0);
#endif

extern int uname_db(struct utsname *);
CheckInterfacedef(uname,uname_db);
#ifdef TET_TEST
if (pcnt == cnt )
	tet_result(TET_PASS);
else
	tet_result(TET_FAIL);
return;
#else
printf("%d tests passed out of %d tests in sys/utsname.h\n\n",pcnt,cnt);
return cnt;
#endif

}
