/* $Id: flist.c,v 1.3 1999/05/26 23:52:21 fraserm Exp $
   $Log: flist.c,v $
   Revision 1.3  1999/05/26 23:52:21  fraserm
   added custom command stuff

   Revision 1.2  1999/05/16 19:47:42  fraserm
   *** empty log message ***

   Revision 1.1  1999/04/20 23:42:56  fraserm
   Initial revision

*/

/* file node list utility functions */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include "limo.h"

extern int numcustcmds;

/* clear a file list structure to empty defaults */

void flist_clear(int argc, char *argv[], struct flist *fl)
{
  int i;

  fl->size = 0;
  fl->maxnamelen = 0;
  fl->maxlinklen = 0;
  if (numcustcmds > 0
      && (fl->maxcustlens
	  = (int *) malloc(sizeof(int *) * numcustcmds)) == NULL) {
    fprintf(stderr, "%s: malloc: %s\n", argv[0], strerror(errno));
    exit(ERROR_PROC);
  }
  for (i = 0; i < numcustcmds; ++i) {
    fl->maxcustlens[i] = 0;
  }
  fl->fa = NULL;
}

/* increase the size of a file list and add the element in new to it */

unsigned long flist_append(int argc, char *argv[], struct flist *fl,
			   struct fnode *new)
{
  struct fnode **tmp;
  int i;

  /* increase the size of the array */
  if ((tmp = realloc(fl->fa, (size_t) ((fl->size+1) * sizeof(struct fnode *))))
      == NULL) {
    fprintf(stderr, "%s: flist_append: realloc: %s\n",
	    argv[0], strerror(errno));
    return 0;
  }
  fl->fa = tmp;
  /* assign new to the new element */
  (fl->fa)[fl->size] = new;
  /* inc the max length and link length register if necessary */
  if (new->namelen > fl->maxnamelen) {
    fl->maxnamelen = new->namelen;
  }
  if (new->linklen > fl->maxlinklen) {
    fl->maxlinklen = new->linklen;
  }
  /* ditto for the custom commands, if any */
  for (i = 0; i < numcustcmds; ++i) {
    if (new->custlens[i] > fl->maxcustlens[i]) {
      fl->maxcustlens[i] = new->custlens[i];
    }
  }
  /* increase the noted size of the array, and return it */
  return (++(fl->size));
}

void flist_free(struct flist *fl)
{
  if (fl->size > 0 && fl->fa != NULL) {
    int i;

    for (i = 0; i < fl->size; ++i) {
      fnode_free(fl->fa[i]);
    }
    if (numcustcmds > 0) {
      free(fl->maxcustlens);
    }
    free(fl->fa);
  }
}

/* sort a list with qsort according to what dir and chunk are */
void flist_sort(int argc, char *argv[], struct flist *fl)
{
  qsort(fl->fa, fl->size, sizeof(struct fnode *), fnode_compare);
}
