/* ----------------------------------------------------------------------
   LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
   http://lammps.sandia.gov, Sandia National Laboratories
   Steve Plimpton, sjplimp@sandia.gov

   Copyright (2003) Sandia Corporation.  Under the terms of Contract
   DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
   certain rights in this software.  This software is distributed under 
   the GNU General Public License.

   See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(npt/sphere,FixNPTSphere)

#else

#ifndef LMP_FIX_NPT_SPHERE_H
#define LMP_FIX_NPT_SPHERE_H

#include "fix_npt.h"

namespace LAMMPS_NS {

class FixNPTSphere : public FixNPT {
 public:
  FixNPTSphere(class LAMMPS *, int, char **);
  ~FixNPTSphere() {}
  void init();
  void initial_integrate(int);
  void final_integrate();

 private:
  double factor_rotate;
};

}

#endif
#endif
