/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include "panel_main.hpp"
#include "lifeobase.hpp"


using namespace LIFEO;


PanelMain::PanelMain( void )
:	m_bhist_index( 0 ), m_ptr2widget( NULL ), m_flag_index_locked( false )
{
	Lifeobase::builder->get_widget( "vbox_panel_main", m_vbox_content );

	for( int i = 0; i < BROWSING_HISTORY_SIZE; i++ )
		m_browsing_history[ i ] = NULL;
}

void
PanelMain::show( DiaryElement *element, Gtk::Widget *widget )
{
	// prepare last element for hiding:
	if( m_browsing_history[ m_bhist_index ] )
		m_browsing_history[ m_bhist_index ]->prepare_for_hiding();

	// add new element to the history:
	if( ! m_flag_index_locked )	// locked while going back
	{
		// TODO: consider duplicate elements?
		m_bhist_index = ( m_bhist_index + 1 ) % BROWSING_HISTORY_SIZE;
		m_browsing_history[ m_bhist_index ] = element;
	}

	if( m_ptr2widget != widget )
	{
		if( m_ptr2widget )
		{
			m_vbox_content->remove( *m_ptr2widget );
		}
		m_vbox_content->pack_start( *widget );
		m_ptr2widget = widget;
	}
}

void
PanelMain::go_back( void )
{
	for( unsigned int i = ( m_bhist_index - 1 + BROWSING_HISTORY_SIZE ) % BROWSING_HISTORY_SIZE;
		 i != m_bhist_index;
		 i = ( i - 1 + BROWSING_HISTORY_SIZE ) % BROWSING_HISTORY_SIZE )
	{
		if( m_browsing_history[ i ] != NULL )
		{
			m_flag_index_locked = true;
			m_browsing_history[ i ]->show();
			m_bhist_index = i;
			m_flag_index_locked = false;
			return;
		}
	}
}

void
PanelMain::remove_element_from_history( DiaryElement *element )
{
	// TODO: this function must be improved
	for( int i = 0; i < BROWSING_HISTORY_SIZE; i++ )
	{
		if( m_browsing_history[ i ] == element )
			m_browsing_history[ i ] = NULL;
	}
}

void
PanelMain::clear_history( void )
{
	for( int i = 0; i < BROWSING_HISTORY_SIZE; i++ )
		m_browsing_history[ i ] = NULL;
}
