/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include "lifeobase.hpp"


namespace LIFEO
{
// STATIC MEMBERS
Lifeobase							*Lifeobase::base;
Settings							Lifeobase::m_settings;
Icons								*Lifeobase::icons = NULL;
Glib::RefPtr< Gdk::Pixbuf >			Lifeobase::pixbuf_background;
Glib::RefPtr< Gtk::Builder >		Lifeobase::builder;
Glib::RefPtr< Gtk::ActionGroup >	Lifeobase::m_actions;
int									Lifeobase::m_internaloperation = 0;
int									Lifeobase::m_entrycount = 0;
bool								Lifeobase::flag_allocate_gui_for_dairy = true;
Gtk::Button							*Lifeobase::m_button_gui_elem;
Gtk::Image							*Lifeobase::m_image_gui_elem;
Gtk::HBox							*Lifeobase::m_hbox_gelem_header;
Gtk::Widget							*Lifeobase::m_current_gelem_toolbar = NULL;
sigc::connection					Lifeobase::m_connection_timeout;
SignalVoid							Lifeobase::m_signal_logout;


Lifeobase::Lifeobase()
:	m_contentwidget( NULL )
{
	base = this;
	m_actions = Gtk::ActionGroup::create( "main actions" );

	drag_targets_tag.push_back( Gtk::TargetEntry( TARGET_ENTRY_TAG,
												  Gtk::TARGET_SAME_APP,
												  DRAG_TARGET_TAG_INFO ) );
	drag_targets_theme.push_back( Gtk::TargetEntry( TARGET_ENTRY_THEME,
													Gtk::TARGET_SAME_APP,
													DRAG_TARGET_THEME_INFO ) );
	drag_targets_entry.push_back( Gtk::TargetEntry( TARGET_ENTRY_ENTRY,
													Gtk::TARGET_SAME_APP,
													DRAG_TARGET_ENTRY_INFO ) );

	// ICONS
	icons = new Icons;
	Glib::RefPtr< Gtk::IconTheme > theme = Gtk::IconTheme::get_default();
	icons->diary_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/diary-16.png" );
	icons->diary_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/diary-32.png" );
	icons->entry_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/entry-16.png" );
	icons->entry_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/entry-32.png" );
	icons->entry_favorite_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/favorite-16.png" );
	icons->tag_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/tag-16.png" );
	icons->tag_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/tag-32.png" );
	icons->tag_category_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/category_tags-16.png" );
	icons->tag_category_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/category_tags-32.png" );
	icons->chapter_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/chapter-16.png" );
	icons->chapter_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/chapter-32.png" );
	//icons->theme_16 = theme->load_icon( "gtk-select-color", 16 );
	icons->theme_32 = theme->load_icon( "gtk-select-color", 32 );
	icons->month_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/month-16.png" );
	icons->month_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/month-32.png" );
	icons->filter_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/filter-16.png" );
}

bool
Lifeobase::load_gui( const std::string &path )
{
	builder = Gtk::Builder::create();
	try
	{
		builder->add_from_file( path );
	}
	catch( const Glib::FileError& ex )
	{
		std::cerr << "FileError: " << ex.what() << std::endl;
		return false;
	}
	catch( const Gtk::BuilderError& ex )
	{
		std::cerr << "BuilderError: " << ex.what() << std::endl;
		return false;
	}

	return true;
}

void
Lifeobase::create_action(	Glib::RefPtr< Gtk::Action >			&action,
							/*Glib::RefPtr< Gtk::ActionGroup >	&actiongroup,*/
							const Glib::ustring					&name,
							const Gtk::StockID					&stockid,
							const Glib::ustring					&label,
							const Glib::ustring					&tooltip,
							const Gtk::AccelKey					&accelkey,
							const Glib::SignalProxy0< void >::SlotType
																&slot,
							Gtk::Widget							*widget_proxy )
{
	action  = Gtk::Action::create( name, stockid, label, tooltip );
	m_actions->add( action, accelkey );
	action->set_accel_group( base->get_accel_group() );
	action->connect_accelerator();
	if( widget_proxy != NULL )
		action->connect_proxy( *widget_proxy );
	action->signal_activate().connect( slot );
}

void
Lifeobase::set_header_texts( const Glib::ustring &title,
							 const Glib::ustring &extra,
							 const Glib::ustring &title_tooltip )
{
	m_label_gui_elem->set_text( title );
	m_label_gui_elem->set_tooltip_markup( title_tooltip );
	m_label_gui_elem_extra->set_text( extra );
}

void
Lifeobase::set_gelem_toolbar( Gtk::Widget *toolbar )
{
	if( m_current_gelem_toolbar != NULL )
		m_hbox_gelem_header->remove( *m_current_gelem_toolbar );

	m_current_gelem_toolbar = toolbar;

	if( toolbar != NULL )
		m_hbox_gelem_header->pack_start( *toolbar, false, false );
}


// DIALOGEVENT
DialogEvent::DialogEvent( const Glib::ustring &title )
: Gtk::Dialog( title )
{
	set_transient_for( *Lifeobase::base );
	Lifeobase::signal_logout().connect( sigc::mem_fun( *this, &DialogEvent::handle_logout ) );
}

DialogEvent::DialogEvent(	BaseObjectType *cobject,
							const Glib::RefPtr< Gtk::Builder >& )
:	Gtk::Dialog( cobject )
{
	set_transient_for( *Lifeobase::base );
}

bool
DialogEvent::on_event( GdkEvent *event )
{
	return Lifeobase::base->on_event( event );
}

void
DialogEvent::handle_logout( void )
{
	hide();
}

/*

// wraps Dialog::run() to add activity reporting
int
Lifeobase::run_dialog( Gtk::Dialog *dialog, bool flag_connect_event )
{
//	if( m_diary.is_encrypted() && m_settings.autologout )
	if( flag_connect_event )
	{
		m_connection_event.disconnect();
		m_connection_event = dialog->signal_event().connect(
				sigc::ptr_fun( Lifeobase::handle_event ) );
	}

	int result = dialog->run();

	if( flag_connect_event )
	{
		m_connection_event.disconnect();
		m_connection_event = m_window->signal_event().connect(
				sigc::mem_fun( *this, &Lifeograph::handle_event ) );
	}

	return result;
}
*/

} // end of namespace LIFEO

