/***********************************************************************************

	Copyright (C) 2007-2010 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_VIEWS_HEADER
#define LIFEOGRAPH_VIEWS_HEADER


#include "diarydata.hpp"
#include "entry.hpp"
#include "widget_chart.hpp"
#include "dialog_export.hpp"
#include "dialog_password.hpp"


namespace LIFEO
{

// DIARY ELEMENT VIEW ==========================================================
class GUIElement // BEWARE: subject to removal
{
	public:
		typedef sigc::signal< void, Gtk::Widget* >
								Signal_void_Widget;
		typedef sigc::signal< void, DiaryElement* >
								Signal_DiaryElement;
		typedef sigc::signal< void, const Date& >
								Signal_Date;
};

// TAG VIEW ====================================================================
class TagView : public Tag::Shower
{
	public:
								TagView( void );

		void					show( Tag &tag );

		void					handle_filter_toggled( void );
		void					handle_name_changed( void );
		void					handle_name_applied( void );
		void					handle_category_changed( void );
		bool					is_row_separator( const Glib::RefPtr< Gtk::TreeModel >&,
												  const Gtk::TreeIter );

		void					update_combobox_categories( void );

		void					dismiss_tag( void );

		Gtk::VBox				*m_vbox;
		Gtk::Alignment			*m_alignment_toolbar;
		Gtk::ToggleButton		*m_button_filter;
		Gtk::Button				*m_button_dismiss;
		Gtk::Entry				*m_entry_name;
		Gtk::Button				*m_button_name_apply;
		Gtk::ComboBox			*m_combobox_category;
		WidgetChart				*m_widgetchart;

	protected:
		enum TagComboType { TCT_NONE, TCT_CATEGORY, TCT_NEW, TCT_SEPARATOR };

		class ColrecCategory : public Gtk::TreeModel::ColumnRecord
		{
			public:
				ColrecCategory() { add( name ); add( ptr ); add( type ); }
				Gtk::TreeModelColumn< Glib::ustring >		name;
				Gtk::TreeModelColumn< CategoryTags* >		ptr;
				Gtk::TreeModelColumn< TagComboType >		type;
		};

		Tag						*m_ptr2tag;	//current tag

		Glib::RefPtr< Gtk::ListStore >
								m_liststore_categories;
		ColrecCategory			colrec_category;

};

// TAG CATEGORY VIEW ===========================================================
class CategoryTagsView : public CategoryTags::Shower
{
	public:
								CategoryTagsView( void );

		void					show( CategoryTags& );

	protected:
		void					handle_name_changed( void );
		void					handle_name_applied( void );
		void					dismiss_category( void );

		Gtk::VBox				*m_vbox;
		Gtk::Alignment			*m_alignment_toolbar;
		Gtk::Entry				*m_entry_name;
		Gtk::Button				*m_button_name_apply;
		Gtk::Button				*m_button_dismiss;

		CategoryTags			*m_ptr2category;
};

// CHAPTER VIEW ================================================================
class ChapterView : public Chapter::Shower
{
	public:
								ChapterView( void );

		void					show( Chapter& );

	protected:
		void					handle_name_changed( void );
		void					handle_name_applied( void );

		Gtk::VBox				*m_vbox;
		Gtk::Entry				*m_entry_name;
		Gtk::Button				*m_button_name_apply;
		Gtk::Entry				*m_entry_begins;
		Gtk::Label				*m_label_ends;

		Chapter					*m_ptr2chapter;
};

// THEME VIEW ==================================================================
class ThemeView : public Theme::Shower
{
	public:
								ThemeView( void );

		void					show( Theme& );

	protected:
		Gtk::VBox				*m_vbox;
		Gtk::Alignment			*m_alignment_toolbar;
		Gtk::Entry				*m_entry_name;
		Gtk::Button				*m_button_name_apply;
		Gtk::FontButton			*m_fontbutton;
		Gtk::ColorButton		*m_colorbutton_bground;
		Gtk::ColorButton		*m_colorbutton_text;
		Gtk::ColorButton		*m_colorbutton_heading;
		Gtk::ColorButton		*m_colorbutton_subheading;
		Gtk::ColorButton		*m_colorbutton_highlight;

		Gtk::Button				*m_button_duplicate;
		Gtk::Button				*m_button_dismiss;
		Gtk::Button				*m_button_make_default;

		Theme					*m_ptr2theme;

		void					handle_name_changed( void );
		void					handle_name_applied( void );
		void					handle_font_changed( void );
		void					handle_color_changed( void );

		void					duplicate( void );
		void					make_default( void );
		void					dismiss_theme( void );
};

// DIARY VIEW ==================================================================
class DiaryView : public Diary::Shower
{
	public:
								DiaryView( void );
								~DiaryView( void );

		void					update_combobox_chapter_ctg( void );

		void					show( Diary& );

		// DIALOGS
		void					start_dialog_password( void );
		void					start_dialog_import( void );
		void					start_dialog_export( void );
		void					start_dialog_chaptereditor( void );
		void					open_diary_folder( void );

	protected:
		void					handle_cur_chapter_ctg_changed( void );
		void					rename_cur_chapter_ctg( void );
		void					dismiss_cur_chapter_ctg( void );
		bool					is_row_separator( const Glib::RefPtr< Gtk::TreeModel >&,
												  const Gtk::TreeIter );

		Gtk::VBox				*m_vbox_diary;
		Gtk::Label				*m_label_path;
		Gtk::Label				*m_label_encryption;
		Gtk::Button				*m_button_logoutwosaving;
		Gtk::CheckButton		*m_checkbutton_autologout;
		Gtk::Button				*m_button_password;

		// CHAPTER CATEGORIES
		Gtk::ComboBoxEntry		*m_combobox_chapter_ctg;
		Gtk::Button				*m_button_chapter_ctg_dismiss;
		Gtk::Button				*m_button_chapter_ctg_rename;

		enum ChapterCtgComboType { CCCT_NONE, CCCT_CATEGORY, CCCT_NEW, CCCT_SEPARATOR };

		class ColrecChapterCtg : public Gtk::TreeModel::ColumnRecord
		{
			public:
				ColrecChapterCtg() { add( name ); add( ptr ); add( type ); }
				Gtk::TreeModelColumn< Glib::ustring >		name;
				Gtk::TreeModelColumn< CategoryChapters* >	ptr;
				Gtk::TreeModelColumn< ChapterCtgComboType >	type;
		};

		Glib::RefPtr< Gtk::ListStore >
								m_liststore_chapter_ctg;
		ColrecChapterCtg		colrec_chapter_ctg;

		// DIALOGS
		DialogPassword			*m_dialog_password;
		DialogImport			*m_dialog_import;

		Diary					*m_ptr2diary;

	friend class Lifeograph;
};

} // end of namespace LIFEO

#endif

