/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_PANEL_MAIN_HEADER
#define LIFEOGRAPH_PANEL_MAIN_HEADER


#include <gtkmm.h>

#include "diarydata.hpp"


namespace LIFEO
{

static const int		BROWSING_HISTORY_SIZE = 5;


class PanelMain
{
	private:
		typedef DiaryElement* PtrDiaryElement;

	public:
								PanelMain( void );

		void					show( DiaryElement*, Gtk::Widget* );
	
		void					go_back( void );
		//void					go_forward( void );

		void					remove_element_from_history( DiaryElement* );
		void					clear_history( void );

		PtrDiaryElement			get_cur_elem( void )
		{ return( m_browsing_history[ m_bhist_index ] ); }
		DiaryElement::Type		get_cur_elem_type( void )
		{
			return( m_browsing_history[ m_bhist_index ] == NULL ?
					DiaryElement::IT_NONE : m_browsing_history[ m_bhist_index ]->get_type() );
		}

		PtrDiaryElement			m_browsing_history[ BROWSING_HISTORY_SIZE ];
		unsigned int			m_bhist_index;	// browsing history index

		Gtk::Widget				*m_ptr2widget;
		Gtk::VBox				*m_vbox_content;

		bool					m_flag_index_locked;
};


} // end of namespace LIFEO

#endif
