/***********************************************************************************

	Copyright (C) 2009 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_CHAPTEREDITOR_HEADER
#define LIFEOGRAPH_DIALOG_CHAPTEREDITOR_HEADER


#include <gtkmm/dialog.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/button.h>
#include <gtkmm/stock.h>

#include "database.hpp"


namespace LIFEO
{
	namespace STRING
	{
		const char NOT_SET_ITALIC[] = N_("<i>not set</i>");
	}

class CellrendererTextEditable : public Gtk::CellRendererText
{
	public:
};

class ColrecChapterset : public Gtk::TreeModel::ColumnRecord
{
	public:
		ColrecChapterset()
		{
			//~ add( m_icon );
			add( m_name );
			add( m_ptr2group );
		}

		// COLUMNS
		//~ Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >		m_icon;
		Gtk::TreeModelColumn< Glib::ustring >					m_name;
		Gtk::TreeModelColumn< Chapterset* >						m_ptr2group;
};

class ColrecChapter : public Gtk::TreeModel::ColumnRecord
{
	public:
		ColrecChapter()
		{
			//~ add( m_icon );
			add( m_name );
			add( m_date );
			add( m_ptr2chapter );
		}

		// COLUMNS
		//~ Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >		m_icon;
		Gtk::TreeModelColumn< Glib::ustring >					m_name;
		Gtk::TreeModelColumn< Glib::ustring >					m_date;
		Gtk::TreeModelColumn< Chapter* >						m_ptr2chapter;
};


class DialogChaptereditor : public Gtk::Dialog
{
	public:
		explicit						DialogChaptereditor( Database* );

		void							populate_groups( void );
		void							populate_chapters( const Chapterset* );

		bool							is_groups_changed( void )
		{ return m_flag_groups_changed; }

		void							handle_groups_selection_changed( void );
		void							handle_chapters_selection_changed( void );

		void							handle_editing_groupname(
												Gtk::CellEditable*,
												const Glib::ustring& );
		void							handle_editing_chaptername(
												Gtk::CellEditable*,
												const Glib::ustring& );
		void							handle_editing_chapterdate(
												Gtk::CellEditable*,
												const Glib::ustring& );

		void							handle_edited_groupname(
												const Glib::ustring&,
												const Glib::ustring& );
		void							handle_edited_chaptername(
												const Glib::ustring&,
												const Glib::ustring& );
		void							handle_edited_chapterdate(
												const Glib::ustring&,
												const Glib::ustring& );

		void							handle_celldata_groupname(
												Gtk::CellRenderer*,
												const Gtk::TreeModel::iterator& );
		void							handle_celldata_chaptername(
												Gtk::CellRenderer*,
												const Gtk::TreeModel::iterator& );
		void							handle_celldata_chapterdate(
												Gtk::CellRenderer*,
												const Gtk::TreeModel::iterator& );

		void							add_group( void );
		void							add_chapter( void );
		void							remove_group( void );
		void							remove_chapter( void );

	protected:
		Gtk::TreeView					*m_treeview_groups;
		Gtk::TreeView					*m_treeview_chapters;
		CellrendererTextEditable		*m_cellrenderertext_groupname;
		CellrendererTextEditable		*m_cellrenderertext_chaptername;
		CellrendererTextEditable		*m_cellrenderertext_chapterdate;
		Gtk::TreeViewColumn				*m_treecolumn_setname;
		Gtk::TreeViewColumn				*m_treecolumn_chaptername;
		Gtk::TreeViewColumn				*m_treecolumn_chapterdate;
		Gtk::Entry						*m_entry_tagname;
		Gtk::Button						*m_button_group_add;
		Gtk::Button						*m_button_group_remove;
		Gtk::Button						*m_button_chapter_add;
		Gtk::Button						*m_button_chapter_remove;
		Glib::RefPtr< Gtk::ListStore >	m_liststore_groups;
		Glib::RefPtr< Gtk::ListStore >	m_liststore_chapters;
		ColrecChapterset				m_colrec_sets;
		ColrecChapter					m_colrec_chapters;

		Database						*m_ptr2database;
		Chapterset						*m_ptr2group;
		bool							m_flag_groups_changed;
};

} // end of namespace LIFEO

#endif

