#!/bin/sh

# /proc/net/dev is of format:
#  eth0: 3060584   34117    0    0    0     0          0        62 12664336   30804    0    0    0     3       0          0
# BASH SUCKS!!!! $[ ] checks the length of the numbers.
# It can handle the number 978796983 - but can't handle 0978796983!!!


led_netload () {
    if test -z "$1" -o -z "$2"; then
	echo "bad command-line options" >&2
	return 1
    fi

    IN=""
    OUT=""
    case "$2" in
	in|IN)
	    IN=`grep "$1:" /proc/net/dev | tr ":" " " | awk '{ print $2 }'`
	    OUT=""
	    ;;
	out|OUT)
	    IN=""
	    OUT=`grep "$1:" /proc/net/dev | tr ":" " " | awk '{ print $10 }'`
	    ;;
	both|BOTH)
	    IN=`grep "$1:" /proc/net/dev | tr ":" " " | awk '{ print $2 }'`
	    OUT=`grep "$1:" /proc/net/dev | tr ":" " " | awk '{ print $10 }'`
	    ;;
	*)
	    echo "bad command-line option $2" >&2
	    return 1
	    ;;
    esac

    # Check for interface existance
    if test -z "$IN" -a -z "$OUT"; then
	return 1
    fi
    # Make them numbers.
    test -z "$IN" && IN=0
    test -z "$OUT" && OUT=0

    # Has to use bc in order to avoid overflow.
    VALUE=`echo "( $IN + $OUT ) / 1024" | bc`

    TIME=`date +%s`

    # Retrieve the old values.
    eval 'OLDVALUE=$LED_NETLOAD_VALUE_'$COUNT
    eval 'OLDTIME=$LED_NETLOAD_TIME_'$COUNT

    test -z "$OLDVALUE" && OLDVALUE=0
    test -z "$OLDTIME" && OLDTIME=0

    # Don't check too often - the values may be too inaccurate.
    # Even 5 secs gives max. inaccuracy of 20%.
    if test $[ $TIME - $OLDTIME ] -lt 5; then
	SUCCESS=nop
	return 0
    fi

    # Save the new values.
    eval 'LED_NETLOAD_TIME_'$COUNT'=$TIME'
    eval 'LED_NETLOAD_VALUE_'$COUNT'=$VALUE'

    if test "$OLDVALUE" = "0" -o "$VALUE" -lt "$OLDVALUE" ; then
	# This is either the first call, so we have no stats or
	# an overflow has occurred in /proc/net/dev, we will just
	# ignore it (they occur about once every 4GB).
	SUCCESS=nop
	return 0
    fi

    KBPS=`echo " ( 0$VALUE - 0$OLDVALUE ) / ( 0$TIME - 0$OLDTIME )" |bc`
    SUCCESS="$SUCCESS $KBPS"
    return 0
}


