/***************************************************************************
 *
 *  $Id: jukebox.cpp,v 1.4 2005/07/02 22:48:43 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <kdebug.h>
#include <klocale.h>

#include "config.h"

#include "jukebox.h"

Jukebox * Jukebox::fgJukebox = 0;

Jukebox::Jukebox()
{
  fJukeboxType = 0xFF;
  fJukeboxTypeName = i18n("Unknown");
  fProductName = i18n("Unknown");
  fHardwareMajor = 0;
  fHardwareMinor = 0;
  fHardwareRelease = 0;
  fFirmwareMajor = 0;
  fFirmwareMinor = 0;
  fFirmwareRelease = 0;
  fLibraryCount = 0;
}

Jukebox::~Jukebox()
{
  fgJukebox = 0;
}

#define VERSION_CODE(major, minor, release) ((major*1000+minor)*1000+release)

void Jukebox::setNJB(njb_t * fNJB)
{
  fJukeboxType = fNJB->device_type;

#if LIBNJB_VERSION_CODE < VERSION_CODE(2,2,0)
  fProductName = fNJB->njbid->productName;

  if (fJukeboxType==NJB_DEVICE_NJB1) {
    fHardwareMajor = 0;
    fHardwareMinor = 0;
    fHardwareRelease = 0;

    fFirmwareMajor = fNJB->njbid->fwMajor;
    fFirmwareMinor = fNJB->njbid->fwMinor;
    fFirmwareRelease = 0;
  } else {
    fHardwareMajor = fNJB->njbid->hwMajor;
    fHardwareMinor = fNJB->njbid->hwMinor;
    fHardwareRelease = fNJB->njbid->hwRel;
    
    fFirmwareMajor = fNJB->njbid->fwMajor;
    fFirmwareMinor = fNJB->njbid->fwMinor;
    fFirmwareRelease = fNJB->njbid->fwRel;
  }

  switch (fJukeboxType) {
  case NJB_DEVICE_NJB1:
    fJukeboxTypeName = "Nomad Jukebox 1";
    break;
  case NJB_DEVICE_NJB2:
    fJukeboxTypeName = "Nomad Jukebox 2";
    break;
  case NJB_DEVICE_NJB3:
    fJukeboxTypeName = "Nomad Jukebox 3";
    break;
  case NJB_DEVICE_NJBZEN:
    fJukeboxTypeName = "Nomad Jukebox Zen";
    break;
  case NJB_DEVICE_NJBZEN2:
    fJukeboxTypeName = "Nomad Jukebox Zen USB 2.0";
    break;
  case NJB_DEVICE_NJBZENNX:
    fJukeboxTypeName = "Nomad Jukebox Zen NX";
    break;
  case NJB_DEVICE_NJBZENXTRA:
    fJukeboxTypeName = "Nomad Jukebox Zen Xtra";
    break;
  case NJB_DEVICE_DELLDJ:
    fJukeboxTypeName = "Dell Digital Jukebox";
    break;
  case NJB_DEVICE_NJBZENTOUCH:
    fJukeboxTypeName = "Creative Jukebox Zen Touch";
    break;
  case NJB_DEVICE_NJBZENMICRO:
    fJukeboxTypeName = "Creative Jukebox Zen Micro";
    break;
  case NJB_DEVICE_DELLDJ2:
    fJukeboxTypeName = "Second Generation Dell DJ";
    break;
  case NJB_DEVICE_POCKETDJ:
    fJukeboxTypeName = "Dell Pocket DJ";
    break;
  default:
    fJukeboxTypeName = i18n("Unknown");
  }

#else
  fJukeboxTypeName = NJB_Get_Device_Name(fNJB, 0);
  if (fJukeboxTypeName.isNull()) fJukeboxTypeName = i18n("Unknown");
  
  fProductName = NJB_Get_Device_Name(fNJB, 1);
  if (fProductName.isNull()) fProductName = i18n("Unknown");
  
  u_int8_t major, minor, release;

  if (fJukeboxType==NJB_DEVICE_NJB1) {
    fHardwareMajor = 0;
    fHardwareMinor = 0;
    fHardwareRelease = 0;

    if (NJB_Get_Firmware_Revision(fNJB, &major, &minor, &release)==0) {
      fFirmwareMajor = major;
      fFirmwareMinor = minor;
      fFirmwareRelease = release;
    }
  } else {
    if (NJB_Get_Hardware_Revision(fNJB, &major, &minor, &release)==0) {
      fFirmwareMajor = major;
      fFirmwareMinor = minor;
      fFirmwareRelease = release;
    }
    
    if (NJB_Get_Firmware_Revision(fNJB, &major, &minor, &release)==0) {
      fFirmwareMajor = major;
      fFirmwareMinor = minor;
      fFirmwareRelease = release;
    }
  }
#endif

  if (fJukeboxType==NJB_DEVICE_NJB1) {
    fLibraryCount = NJB_Get_NJB1_Libcounter(fNJB);
  } else {
    fLibraryCount = 0;
  }

  kdDebug() << "Jukebox: " 
	    << fJukeboxTypeName << " ("
	    << fJukeboxType << ") "
	    << fProductName << endl;
  kdDebug() << "         Hardware=" 
	    << fHardwareMajor << "."
	    << fHardwareMinor << "."
	    << fHardwareRelease << " Firmware="
	    << fFirmwareMajor << "."
	    << fFirmwareMinor << "."
	    << fFirmwareRelease << endl;
  kdDebug() << "         Librarycounter=" 
	    << (uint) fLibraryCount << endl; 
}

Jukebox * Jukebox::get()
{
  if (!fgJukebox) {
    fgJukebox = new Jukebox();
  }
  return fgJukebox;
}
