/***************************************************************************
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAGICLABEL_H
#define MAGICLABEL_H

#include <qstring.h>

#include <kprocess.h>

class MagicLabel : QObject
{
  Q_OBJECT

  private:
    QString prefix;
    QString preUSER;
    QString preCMD;

    QString mValue;

    void transform();
    void getUserInfo();
    void getCommandOutput();

  private slots:
    void processExited(KProcess* proc);
    void receivedStdout(KProcess *proc, char *buffer, int buflen);

  public:
    MagicLabel(QString s, bool translate);

    inline QString& value() { return mValue; };
};

#endif
