/***************************************************************************
                          replacedialog.h  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef REPLACEDIALOG_H
#define REPLACEDIALOG_H

// QT includes
#include <kdialogbase.h>
#include <qvaluelist.h>

// Own includes
#include "batchrenamer.h"

class QCheckBox;
class QGridLayout; 
class QGridLayout;
class QLabel;
class QLineEdit;
class KPushButton;
class QListViewItem;
class KListView;
class ReplaceDialog : public KDialogBase
{ 
    Q_OBJECT

    public:
        ReplaceDialog( QValueList<replacestrings> & r, QWidget* parent = 0 );
        ~ReplaceDialog();

        QValueList<replacestrings> getList();

    private slots:
        void add();
        void moveFocus();
        void remove();
        void invokeRegEdit();
        void enableControls();
        void slotEdit();
        
    private:
        void reset();

        QLabel* TextLabel1;
        QLineEdit* text2;
        QLabel* TextLabel2;
        QLineEdit* text1;
        KListView* list;
        QCheckBox* checkReg;

        KPushButton* buttonAdd;
        KPushButton* buttonRemove;
        KPushButton* buttonEdit;
        KPushButton* buttonRegEdit;

        QString encode( QString s );
        QString decode( QString s );

    protected:
        void resizeEvent( QResizeEvent* e );

        QGridLayout* ReplaceDialogLayout;
};

#endif // REPLACEDIALOG_H
