/***************************************************************************
                          kmylistview.h  -  description
                             -------------------
    begin                : Mit M� 27 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYLISTVIEW_H
#define KMYLISTVIEW_H

#include "batchrenamer.h"
#include "kmylistbox.h"
#include <klistview.h>
#include <qvaluelist.h>

class QMouseEvent;
class KMyListView : public KListView  {
    Q_OBJECT
    public:
        KMyListView( QValueList<manualchanges>* _changes, KMyListBox* _list, QWidget* parent=0, const char* name=0 );
        ~KMyListView();

    signals:
        void itemChanged();
        void removeItem(int);
        void addFile();
                
    private slots:
        void changeItem( QListViewItem* item, const QPoint&, int );
        void showContext( QListViewItem* item, const QPoint& pos, int );
        void removeCurrentItem();
        void addFiles();
        void changeCurrentItem();
        void openCurrent();

    private:
        QValueList<manualchanges>* changes;
        KMyListBox* list;
};

/////////////////////////////////////////////////////////////
class QColor;
class QString;
class KMyListViewItem : public KListViewItem {
    public:
        KMyListViewItem(QListView *parent);
        KMyListViewItem(QListViewItem *parent);
        KMyListViewItem(QListView *parent, QListViewItem *after);
        KMyListViewItem(QListViewItem *parent, QListViewItem *after);

        KMyListViewItem(bool m, QListView *parent,
            QString, QString = QString::null,
            QString = QString::null, QString = QString::null,
            QString = QString::null, QString = QString::null,
            QString = QString::null, QString = QString::null);

        KMyListViewItem(bool m, QListViewItem *parent,
            QString, QString = QString::null,
            QString = QString::null, QString = QString::null,
            QString = QString::null, QString = QString::null,
            QString = QString::null, QString = QString::null);

        KMyListViewItem(bool m, QListView *parent, QListViewItem *after,
            QString, QString = QString::null,
            QString = QString::null, QString = QString::null,
            QString = QString::null, QString = QString::null,
            QString = QString::null, QString = QString::null);

        KMyListViewItem(QListViewItem *parent, QListViewItem *after,
            QString, QString = QString::null,
            QString = QString::null, QString = QString::null,
            QString = QString::null, QString = QString::null,
            QString = QString::null, QString = QString::null);

        virtual ~KMyListViewItem();

        void paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int alignment );

    private:
        bool modified;
};


#endif
