//
// C++ Implementation: kpgnewobjectdialog
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgnewobjectdialog.h"

#include <qpushbutton.h>
#include <qiconview.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"

KPGNewObjectDialog::KPGNewObjectDialog(QWidget *parent, const char *name, eNewObjectIconSet eIconSet, const QString &strCaption, bool bTablespces)
 : KPGNewObjectDialogBase(parent, name)
{
	if(eIconSet == iconSetServer)
	{
		// Server's objects
    if(bTablespces) (void) new QIconViewItem(m_pIconView, "tablespace", * KPGTreeItem::m_pIconTablespaceUsr);
		(void) new QIconViewItem(m_pIconView, "database", * KPGTreeItem::m_pIconDatabaseUsr);
		(void) new QIconViewItem(m_pIconView, "group", * KPGTreeItem::m_pIconGroup);
		(void) new QIconViewItem(m_pIconView, "user", * KPGTreeItem::m_pIconUser);
	}
  else
  {
    if(eIconSet == iconSetTable)
    {
      (void) new QIconViewItem(m_pIconView, "column", * KPGTreeItem::m_pIconColumnOther);
      (void) new QIconViewItem(m_pIconView, "primary key", * KPGTreeItem::m_pIconPrimaryKeyConstr);
      (void) new QIconViewItem(m_pIconView, "foreign key", * KPGTreeItem::m_pIconForeignKeyConstr);
      (void) new QIconViewItem(m_pIconView, "unique", * KPGTreeItem::m_pIconUniqueConstr);
      (void) new QIconViewItem(m_pIconView, "check", * KPGTreeItem::m_pIconCheckConstr);
      (void) new QIconViewItem(m_pIconView, "index", * KPGTreeItem::m_pIconIndex);
			(void) new QIconViewItem(m_pIconView, "rule", * KPGTreeItem::m_pIconRule);
			(void) new QIconViewItem(m_pIconView, "trigger", * KPGTreeItem::m_pIconTrigger);
    }
	 else
	 {
		  // Databases's and schema's objects
      if(eIconSet == iconSetDatabase)
      {
        (void) new QIconViewItem(m_pIconView, "schema", * KPGTreeItem::m_pIconSchemaUsr);
        (void) new QIconViewItem(m_pIconView, "language", * KPGTreeItem::m_pIconLanguage);
		  }
          
      (void) new QIconViewItem(m_pIconView, "table", * KPGTreeItem::m_pIconTable);
		  (void) new QIconViewItem(m_pIconView, "view", * KPGTreeItem::m_pIconView);
      (void) new QIconViewItem(m_pIconView, "domain", * KPGTreeItem::m_pIconDomain);
      (void) new QIconViewItem(m_pIconView, "function", * KPGTreeItem::m_pIconFunctionSql);
		  (void) new QIconViewItem(m_pIconView, "sequence", * KPGTreeItem::m_pIconSequence);
      (void) new QIconViewItem(m_pIconView, "base type", * KPGTreeItem::m_pIconTypeBase);
      (void) new QIconViewItem(m_pIconView, "composite type", * KPGTreeItem::m_pIconTypeStandalone);
	 }
	}
  
	m_strCaption = strCaption;
	languageChange();
}


KPGNewObjectDialog::~KPGNewObjectDialog()
{
}

void KPGNewObjectDialog::languageChange()
{
    KPGNewObjectDialogBase::languageChange();
		
		setCaption( m_strCaption );
}

void KPGNewObjectDialog::slotItemDoubleClicked(QIconViewItem *pItem)
{
	m_strObjectType = pItem->text();
	KPGNewObjectDialogBase::accept();
}

void KPGNewObjectDialog::slotItemSelectionChanged(QIconViewItem *pItem)
{
	m_pButtonOk->setEnabled(pItem != 0);
}

void KPGNewObjectDialog::accept()
{
	QIconViewItem *pItem = m_pIconView->currentItem();
	
	if(pItem)
	{
		m_strObjectType = pItem->text();
		KPGNewObjectDialogBase::accept();
	}
}

#include "kpgnewobjectdialog.moc"
