//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatesequencewizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "kpgcreatesequencewidget1.h"


KPGCreateSequenceWizard::KPGCreateSequenceWizard(QWidget *parent, const char *name, QPtrList<QListViewItem> & listOfSchemas)
 : KPG3StepsWizard(parent, name)
{
  KPGCreateSequenceWidget1 *pCreateSequenceWidget1 = new KPGCreateSequenceWidget1(WizardPage1, "KPGCreateSequenceWidget1", listOfSchemas);
  m_pPageWidget1 = pCreateSequenceWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateSequenceWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  languageChange();
}

KPGCreateSequenceWizard::~KPGCreateSequenceWizard()
{
}

void KPGCreateSequenceWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Create new sequence" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Sequence name and another properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateSequenceWizard::showPage(QWidget *pPage)
{ 
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    // prepare SQL statement
    QString strSQL;
    strSQL.append((static_cast <KPGCreateSequenceWidget1 *> (m_pPageWidget1))->getSQL());
		strSQL.append(";\n");
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery();
  }
  
  // call parent
  KPG3StepsWizard::showPage(pPage);
}

#include "kpgcreatesequencewizard.moc"
