//
// C++ Implementation: kpgcreatedatabasewidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatedatabasewidget1.h"

// include files for KDE
#include <klineedit.h>
#include <klistbox.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../kpgutil.h"

KPGCreateDatabaseWidget1::KPGCreateDatabaseWidget1(QWidget *parent, const char *name, KPGServer *pServer)
 : KPGCreateDatabaseWidget1Base(parent, name)
{
	m_pLineEditDatabaseName->setFocus();
	
	KPGUsersFolder *pUsersFolder =  pServer->getUsersFolder();
	
	//--- traverse list of users
	QListViewItem * pItem = pUsersFolder->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeUser)
			m_pComboBoxOwner->insertItem(*pItem->pixmap(0), pItem->text(0));
				
		pItem = pItem->nextSibling();
	}
		
	//--- traverse list of databases
	pItem = pServer->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeDatabase)
		{
      KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pItem);
      
      if(pDatabase->isConnected() == false) // only disconnected databases can't be used as template
        m_pComboBoxTemplateDb->insertItem(*pItem->pixmap(0), pItem->text(0));
		}	
		
    pItem = pItem->nextSibling();
	}
}


KPGCreateDatabaseWidget1::~KPGCreateDatabaseWidget1()
{
}

void KPGCreateDatabaseWidget1::slotLineEditDatabaseNameChanged(const QString &strDbName)
{
	emit sigEnableNextButton(strDbName.length() > 0);
}

const QString KPGCreateDatabaseWidget1::getSQL() const
{
	QString strSQL("CREATE DATABASE ");
	
	strSQL.append(KPGUtil::quotedName(m_pLineEditDatabaseName->text()));
	
	QString strWITH(" WITH ");
	
	if(m_pComboBoxOwner->currentItem() > 0)
		strWITH.append("\nOWNER " + KPGUtil::quotedName(m_pComboBoxOwner->currentText()));
	
	if(m_pLineEditLocation->text().length() > 0)
		strWITH.append("\nLOCATION '" + m_pLineEditLocation->text() + "'");
	
	if(m_pComboBoxTemplateDb->currentItem() > 0)
		strWITH.append("\nTEMPLATE " + KPGUtil::quotedName(m_pComboBoxTemplateDb->currentText()));
		
	if(m_pComboBoxEncoding->currentItem() > 0)
		strWITH.append("\nENCODING '" + m_pComboBoxEncoding->currentText() + "'");		
	
  if(m_pComboBoxTablespace->currentItem() > 0)
    strWITH.append("\nTABLESPACE " + KPGUtil::quotedName(m_pComboBoxTablespace->currentText()));
      	
	if(strWITH.length() > 7)
		strSQL.append(strWITH);
	
	return strSQL;
}
		
#include "kpgcreatedatabasewidget1.moc"
