//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpganalysetablewizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtable.h"
#include "kpganalysetablewidget1.h"

KPGAnalyseTableWizard::KPGAnalyseTableWizard(QWidget *parent, const char *name, const QString & strNamespace, KPGTable *pTable)
 : KPG3StepsWizard(parent, name)
{
  KPGAnalyseTableWidget1 *pAnalyseTableWidget1 = new KPGAnalyseTableWidget1(WizardPage1, "KPGAnalyseTableWidget1", strNamespace, pTable);
  m_pPageWidget1 = pAnalyseTableWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pAnalyseTableWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  setNextEnabled(WizardPage1, true);
  languageChange();
}

KPGAnalyseTableWizard::~KPGAnalyseTableWizard()
{
}

void KPGAnalyseTableWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Analyze table" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Analyze table parameters" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGAnalyseTableWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    // prepare SQL statement
    m_pTextEditSQL->setText((static_cast <KPGAnalyseTableWidget1 *> (m_pPageWidget1))->getSQL());
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery(false);
  }
  
  // call parent
  KPG3StepsWizard::showPage(pPage);
}


#include "kpganalysetablewizard.moc"
