//
// C++ Interface: kpgruleproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGRULEPROPPAGE_H
#define KPGRULEPROPPAGE_H

#include "kpgruleproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"


class KPGSyntaxHighlighter;
class KPGRule;


/**
  * Table rules property page
  *
  * @author Lumir Vanek
  */
class KPGRulePropPage : public KPGRulePropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGRulePropPage(QWidget *, KPGRule *);
    ~KPGRulePropPage();

	// Display properties of underlying database object
	virtual void displayProperties();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:
	
	KPGRule * m_pRule;
	
signals:
            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);	
	
public slots:

	// Changes syntax highlighting colors.
	void slotSqlEditorSettingsChanged();
	
	            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
			
protected:
	// Syntax highlighter for rule definition 
  	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
};

#endif
