//
// C++ Implementation: kpgaggregateproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgaggregateproppage.h"

#include <qtable.h>  

#include <kmessagebox.h>
#include <klocale.h>
#include <ktextedit.h>

#include <kdebug.h>

#include "../kpglinklabel.h"
#include "../DbObjects/kpgaggregate.h"
#include "../kpglinklabel.h"


KPGAggregatePropPage::KPGAggregatePropPage(QWidget *parent, KPGAggregate *pAggregate)
 : KPGAggregatePropPageBase(parent, "KPGAggregatePropPage")
{
	m_pAggregate = pAggregate;
	displayProperties();
}


KPGAggregatePropPage::~KPGAggregatePropPage()
{
}

void KPGAggregatePropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

    pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
    m_pTableProperties->setText(iRow, 1, m_pAggregate->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Aggregate name"));
	
	//--- Aggregate function
	m_pTableProperties->setText(iRow, 0, i18n("Aggregate function"));
    KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Aggregate function" );
	pLabel->setValues(m_pAggregate->oidAggregateFn(), m_pAggregate->aggregateFn());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Aggregate function name"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
    m_pTableProperties->setText(iRow, 1, m_pAggregate->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the aggregate"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pAggregate->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the aggregate function"));
		
	//--- Transition function
	m_pTableProperties->setText(iRow, 0, i18n("Transition function"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Transition function" );
	pLabel->setValues(m_pAggregate->oidTransFn(), m_pAggregate->transFn());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Transition function name"));
	
	//--- Final function
	m_pTableProperties->setText(iRow, 0, i18n("Final function"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Final function" );
	pLabel->setValues(m_pAggregate->oidFinalFn(), m_pAggregate->finalFn());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Final function name"));
	
	//--- Input type
	m_pTableProperties->setText(iRow, 0, i18n("Input type"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Input type" );
	pLabel->setValues(m_pAggregate->oidInputType(), m_pAggregate->inputTypName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Aggregate function input type name"));
	
	//--- Transition type
	m_pTableProperties->setText(iRow, 0, i18n("Transition type"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Transition type" );
	pLabel->setValues(m_pAggregate->oidTransType(), m_pAggregate->transTypName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("The type of the aggregate function's internal transition (state) data"));
	
	//--- Return type
	m_pTableProperties->setText(iRow, 0, i18n("Return type"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Return type" );
	pLabel->setValues(m_pAggregate->oidRetType(), m_pAggregate->retTypName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Data type of the aggregate function return value"));
	
	//--- Initial value
	m_pTableProperties->setText(iRow, 0, i18n("Initial value"));
  	m_pTableProperties->setText(iRow, 1, m_pAggregate->initVal());
	m_pTableProperties->setText(iRow++, 2, i18n("The initial value of the transition state. This is a text field containing the initial value in its external string representation. If the value is null, the transition state value starts out null."));
	
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
}

void KPGAggregatePropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}


// Consumes request for context menu for property table
void KPGAggregatePropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgaggregateproppage.moc"
