//
// C++ Implementation: kpgoperator
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgoperator.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgoperatorsfolder.h"


KPGOperator::KPGOperator(KPGOperatorsFolder *parent, const QString name, pqxx::oid _oid)
  : KPGObject(parent, name, _oid)
{
  setPixmap(0, *m_pIconOperator);
}

KPGOperator::KPGOperator(KPGOperatorsFolder *parent, KPGOperator *after, const QString name, pqxx::oid _oid)
  : KPGObject(parent, after, name, _oid)
{
  setPixmap(0, *m_pIconOperator);
}


KPGOperator::~KPGOperator()
{
}

void KPGOperator::setProperties(const pqxx::result::tuple &pqxxTuple, bool bVersion83_OrNewer)
{
    pqxxTuple["oprcanhash"].to(m_bCanHash);
	pqxxTuple["oprleft"].to(m_oidLeftType);
	pqxxTuple["oprright"].to(m_oidRightType);
	pqxxTuple["oprresult"].to(m_oidResultType);
			
	pqxxTuple["oprcom"].to(m_oidComutatorOpr);
	pqxxTuple["oprnegate"].to(m_oidNegatorOpr);
	
	if(bVersion83_OrNewer)
	{
		m_strLeftSortOprName = "N/A";
		m_strRightSortOprName = "N/A";
		m_strLessThanOprName = "N/A";
		m_strGreatherThanOprName = "N/A";
	}
	else
	{
		pqxxTuple["oprlsortop"].to(m_oidLeftSortOpr);
		pqxxTuple["oprrsortop"].to(m_oidRightSortOpr);
		pqxxTuple["oprltcmpop"].to(m_oidLessThanOpr);
		pqxxTuple["oprgtcmpop"].to(m_oidGreatherThanOpr);
		
		m_strLeftSortOprName = pqxxTuple["leftsortop"].c_str();
		m_strRightSortOprName = pqxxTuple["rightsortop"].c_str();
		m_strLessThanOprName = pqxxTuple["lessthancmpop"].c_str();
		m_strGreatherThanOprName = pqxxTuple["greatherthancmpop"].c_str();
	}
	pqxxTuple["oprcodeoid"].to(m_oidOperatorFunc);
	pqxxTuple["oprrestoid"].to(m_oidRestrictionFunc);
	pqxxTuple["oprjoinoid"].to(m_oidJoinFunc);
					
	m_strDescription = pqxxTuple["description"].c_str();
	m_strOwner = pqxxTuple["opowner"].c_str();
	m_strKind = pqxxTuple["oprkind"].c_str();
	m_strLeftType = pqxxTuple["lefttype"].c_str();
	m_strRightType = pqxxTuple["righttype"].c_str();
	m_strResultType = pqxxTuple["resulttype"].c_str();
	m_strComutatorOprName = pqxxTuple["compop"].c_str();
	m_strNegatorOprName = pqxxTuple["negop"].c_str();
	m_strOperatorFunc = pqxxTuple["operproc"].c_str();
	m_strRestrictionFunc = pqxxTuple["restrproc"].c_str();
	m_strJoinFunc = pqxxTuple["joinproc"].c_str();
}

