//                       -*- mode: C++ -*-
//
// Copyright(C) 2005,2006,2007,2008 Stefan Siegl <stesie@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SILCPROTOCOLSILCPROTOCOL_H
#define SILCPROTOCOLSILCPROTOCOL_H

#include <kopeteprotocol.h>
//#include "silcaccount.h"

namespace Kopete {
  class OnlineStatus;
  class ChatSession;
}

// forward declare classes:
class SilcProtocol;
class SilcAccount;

/**
 * @brief Plugin reimplementation to support SILC protocol
 *
 * @author Stefan Siegl <ssiegl@gmx.de>
 */
class SilcProtocol : public Kopete::Protocol
{
  Q_OBJECT

public:
  SilcProtocol(QObject *parent, const QStringList &args);
  ~SilcProtocol();

  /**
   * @brief create new SilcAccount with the provided accountId
   * @param accountId - the unique ID for the new Kopete::Account
   */
  virtual Kopete::Account *createNewAccount(const QString &accountId);

  /**
   * @brief create the AddContactPage widget
   *
   * Create the AddContactPage widget, which is displayed, if the user
   * chooses File > Add Contact and asks to add buddies from the
   * SILC protocol then.
   * @param parent - the parent QWidget
   * @param account - the SilcAccount to add the new Kopete::Contact to
   */
  virtual AddContactPage *createAddContactWidget(QWidget *parent,
						 Kopete::Account *account);

  /**
   * @brief create KopeteEditAccountWidget
   *
   * Create the KopeteEditAccountWidget allowing the user to modify the given
   * account. 
   * @param account - the SilcAccount to modify
   * @param parent - the parent QWidget
   */
  virtual KopeteEditAccountWidget
    *createEditAccountWidget(Kopete::Account *account, QWidget *parent);

  /** 
   * @brief deserialize contact data
   *
   * Deserialize, i.e. read from config file, contact data
   */
  virtual Kopete::Contact 
    *deserializeContact(Kopete::MetaContact *meta,
			const QMap<QString, QString> &serializedData, 
			const QMap<QString, QString> &addressBookData);

  const Kopete::OnlineStatus statusOnline;
  const Kopete::OnlineStatus statusOnlineChannel;
  const Kopete::OnlineStatus statusConnecting;
  const Kopete::OnlineStatus statusHyper;
  const Kopete::OnlineStatus statusGone;
  const Kopete::OnlineStatus statusIndisposed;
  const Kopete::OnlineStatus statusBusy;
  const Kopete::OnlineStatus statusOffline;
  const Kopete::OnlineStatus statusDetached;

  static SilcProtocol *protocol(void);

public slots:
  /**
   * @brief send a /whois request to the server
   *
   * @param nickname - the nickname for which to request the whois
   * @param session - the Kopete::ChatSession issuing the request
   */
  void slotWhoisCommand(const QString &nick, Kopete::ChatSession *);

  void slotKillmeCommand(const QString &nick, Kopete::ChatSession *);

  void slotWatchCommand(const QString &nick, Kopete::ChatSession *cs);

  void slotNoticeCommand(const QString &nick, Kopete::ChatSession *);

  void slotAction(const QString &action, Kopete::ChatSession *);

  void slotGetkeyCommand(const QString &nick, Kopete::ChatSession *);

private:
  static SilcProtocol *_protocol;

  // InternalStatus is used as internal status as well as weight when
  // creating the status instances.
  enum InternalStatus {
    Online = 10,		// Online
    OnlineChannel = 0,		// Online
    Connecting = 0,		// Online
    Hyper = 5,			// Online
    Gone = 10,			// Away
    Indisposed = 5,		// Away
    Busy = 0,			// Away
    Offline = 5,		// Offline
    Detached = 0,		// Offline
  };

};

#endif
