
/***************************************************************************
 *                                                                         *
 *   KNetLoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "scaledialog.h"

#include <cstdlib>
#include <klineedit.h>
#include <klocale.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qvalidator.h>

ScaleDialog::ScaleDialog(int defaultScale, const QString &title,
        QWidget* parent) :
        KDialogBase(parent, "scale dialog", true, title, Ok|Cancel, Ok),
        scale(defaultScale) {
    QHBox* page = makeHBoxMainWidget();

    new QLabel(i18n("Scale in KBit/s:"), page);

    QString scaleStr;
    scaleStr.setNum(defaultScale);
    KLineEdit* scaleBox = new KLineEdit(scaleStr, page);

    QIntValidator* val = new QIntValidator(this);
    val->setBottom(1);
    scaleBox->setValidator(val);

    connect(scaleBox, SIGNAL(textChanged(const QString&)),
        this, SLOT(updateScale(const QString&)));
}

int ScaleDialog::getScale() const {
    return scale;
}

void ScaleDialog::updateScale(const QString& text) {
    scale = text.toInt();
}

#include "scaledialog.moc"
