
/***************************************************************************
 *                                                                         *
 *   KCPULoad and KNetLoad are copyright (c) 1999-2000, Markus Gustavsson  *
 *                                       (c) 2002, Ben Burton              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "icontoggleaction.h"

IconToggleAction::IconToggleAction(
        const QString& useTextUnchecked, const QString& useIconUnchecked,
        const QString& useTextChecked, const QString& useIconChecked,
        const KShortcut& cut, const QObject* receiver, const char* slot,
        QObject* parent, const char* name) :
        KToggleAction(useTextUnchecked, useIconUnchecked, cut, receiver,
        slot, parent, name),
        textChecked(useTextChecked), textUnchecked(useTextUnchecked),
        iconChecked(useIconChecked), iconUnchecked(useIconUnchecked) {
}

IconToggleAction::IconToggleAction(const QString& useText,
        const QString& useIconUnchecked, const QString& useIconChecked,
        const KShortcut& cut, const QObject* receiver, const char* slot,
        QObject* parent, const char* name) :
        KToggleAction(useText, useIconUnchecked, cut, receiver,
        slot, parent, name),
        textChecked(useText), textUnchecked(useText),
        iconChecked(useIconChecked), iconUnchecked(useIconUnchecked) {
}

IconToggleAction::IconToggleAction(
        const QString& useTextUnchecked, const QString& useIconUnchecked,
        const QString& useTextChecked, const QString& useIconChecked,
        const KShortcut& cut, QObject* parent, const char* name) :
        KToggleAction(useTextUnchecked, useIconUnchecked, cut, parent, name),
        textChecked(useTextChecked), textUnchecked(useTextUnchecked),
        iconChecked(useIconChecked), iconUnchecked(useIconUnchecked) {
}

IconToggleAction::IconToggleAction(const QString& useText,
        const QString& useIconUnchecked, const QString& useIconChecked,
        const KShortcut& cut, QObject* parent, const char* name) :
        KToggleAction(useText, useIconUnchecked, cut, parent, name),
        textChecked(useText), textUnchecked(useText),
        iconChecked(useIconChecked), iconUnchecked(useIconUnchecked) {
}

void IconToggleAction::setChecked(bool value) {
    if (value != isChecked()) {
        setText(value ? textChecked : textUnchecked);
        setIcon(value ? iconChecked : iconUnchecked);
    }

    KToggleAction::setChecked(value);
}

#include "icontoggleaction.moc"
