/***************************************************************************
 *   Copyright (C) 2005 by yodor   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DOCKIF_H
#define DOCKIF_H

#include <ksystemtray.h>
#include <qtimer.h>
#include <qstring.h>
#include <qtooltip.h>
#include <qpixmap.h>
#include <qmutex.h>
#include <qcolor.h>

#include "chartframe.h"
#include "qevent.h"
#include "ttip.h"
#include "knetdockif.h"
/**
@author yodor
*/

class TTip;

class DockIf : public KSystemTray
{
Q_OBJECT

public:
    DockIf(QWidget *parent, const char* name);
   ~DockIf();

	void update(const KNetDockIf *);
	bool isTipEnabled();
	bool isUseChart();
	void setUseChart(bool mode);
	void setLedColor(const QColor& clr);


public slots:
	void toggleTip();

	void updateChartStyle(int);
	void chooseLedColor();

protected:
    virtual void paintEvent (QPaintEvent *);
// 	virtual bool event (QEvent *);
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void leaveEvent ( QEvent * );

private:
	QString dev_name;
// 	QMutex mutex;

	TTip *tip;
	bool tipEnabled;
	bool useChart;

	ChartFrame *c;
	QPixmap *pbuf;
	
	QColor led_color;
	QPixmap base;
	QPixmap link_off;
	QPixmap led_off;
	QPixmap led;
	void createLedIcon(const QColor& clr);
	void loadLedColor();
	void clear();
	
};

#endif
