//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruletargetoptioneditlog.h"


// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../ipteditor/kmfruleedit.h"
#include "kmfruleedittargetlog.h"

namespace KMF {
KMFRuleTargetOptionEditLog::KMFRuleTargetOptionEditLog(QObject *parent, const char *name)
		: KMFRuleTargetOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleTargetOptionEditLog::KMFRuleTargetOptionEditLog(QObject *parent, const char *name)" << endl;
	
	m_managedTargets << "LOG";
	
	
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditTargetLog( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,SIGNAL(sigHideMe() ), 
		this,SLOT( slotShowOverview() ) );
}
KMFRuleTargetOptionEditLog::~KMFRuleTargetOptionEditLog() {}

void KMFRuleTargetOptionEditLog::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleTargetOptionEditLog::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}


const QString& KMFRuleTargetOptionEditLog::optionEditName() const {
	return *( new QString( i18n("NAT Option") ) );
}
const QString& KMFRuleTargetOptionEditLog::description() const {
	return *( new QString( i18n("This plugin manages the NAT options of iptables.") ) );
}

void KMFRuleTargetOptionEditLog::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleTargetOptionEditLog::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

QWidget* KMFRuleTargetOptionEditLog::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleTargetOptionEditLog::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}

bool KMFRuleTargetOptionEditLog::setTarget( const QString& target ){
	if ( ! manageTarget( target ) ) {
		return false;
	}
	return true;
}



// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleTargetOptionEditLogFactory::s_instance = 0L;
// KAboutData* KMFRuleTargetOptionEditLogFactory::s_about = 0L;

KMFRuleTargetOptionEditLogFactory::KMFRuleTargetOptionEditLogFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleTargetOptionEditLogFactory" );
}

QObject* KMFRuleTargetOptionEditLogFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFRuleTargetOptionEditLog( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleTargetOptionEditLogFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleTargetOptionEditLogFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruletargetoptionedit_log() {
		return new KMFRuleTargetOptionEditLogFactory;
	}
}


}

#include "kmfruletargetoptioneditlog.moc"
