/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2008
*/
#ifndef KMFTARGET_H
#define KMFTARGET_H

#include "netfilterobject.h"

// QT includes

#include <qptrlist.h>
#include <qstring.h>
#include <qdom.h>

// KDE includes
#include <kdemacros.h>
#include <kprocess.h>

// Project includes
#include "kmfnetzone.h"

#include "xmlnames.h"
class QWidget;

namespace KMF {
class IPAddress;
class KMFError;
class KMFTargetConfig;
class KMFDoc;
class KMFNetwork;
class KMFRulesetDoc;
class KMFProcessWrapper;
class KMFInstallerInterface;
class KMFCompilerInterface;
/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/

class KDE_EXPORT KMFTarget : public NetfilterObject {
	Q_OBJECT
public:
	KMFTarget( NetfilterObject *parent, const char* name, const QString& targetName, KMFNetwork* net );

    ~KMFTarget();
	
	virtual int type();
	virtual void clear();
	
	virtual const QDomDocument& getDOMTree();
	virtual void loadXML(const QDomDocument&, QStringList& errors );
	virtual void loadXML( QDomNode, QStringList& errors );
	
	KMFNetZone* zone() const {
		return m_zone;
	}
	
	bool isLocalhost(); 
	bool isLocalExecuteTarget(); 
	
	const QString& guiName() const {
		return m_guiName;
	};
	void setGuiName( const QString& );

	const QString& name();

	IPAddress* address() {
		return m_address;
	};
	
	void setAddress( const QString& );
	
	int sshPort() const {
		return m_ssh_port;
	};
	
	void setSSHPort( int );
	
	bool readOnly() const {
		return m_readOnly;
	};
	void setReadOnly( bool );	

	bool isCurrentTarget();
	KMFNetwork* network();
	
	void setParentZone( KMFNetZone* );
	KMFError* tryAutoConfiguration();
	
	KMFTargetConfig* config();
	
	QString toString();
	QString toFriendlyString();
	const QString& getFishUrl();
	
	
	KMFDoc* doc();
	
	KMFRulesetDoc* rulesetDoc();
	KMFInstallerInterface* installer();
	KMFCompilerInterface* compiler();
	
	protected: 
		QGuardedPtr<KMFNetZone> m_zone;
		IPAddress *m_address;
		int m_ssh_port;
		QString m_guiName;
		
	private:
		void ensureDoc();
		KMFTargetConfig *m_config;
		KMFDoc *m_doc;
		KMFNetwork *m_network;
		bool m_readOnly;
		QString m_allOut;	
	signals:
		void sigTargetChanged( KMFTarget* );
};	
}
#endif
