#ifndef __OPSTACK_CLASS__
#define __OPSTACK_CLASS__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <qvalidator.h>

class Device;
class QString;
#include<value.h>
class Fifo;
template <class T> class KlogicList;

#include "calculator.h"
#include "calcRules.h"

class Calculator : public DelayedValue {
public:
	static int instance;

	Calculator();
	Calculator(Device *, int, int);
	virtual ~Calculator();

	void setEquation(char);			// set single operator as equation (no named inputs)
	void setEquation(const QChar&);		// set equation
	void setEquation(const QString&);	// set equation
	const QString& getEquation() const;	// return equation
	QString getEquation(const QString&) const;	// return prefixed equation
	int hasEquation();			// return wether we have an equation or not

	virtual const QueueInfo& parse();	// parse current equation, build calculation stack

	void push(int);				// push values to the calculation stack
	int calculate(bool);			// calculate the stack, return the result (needs a dev)

	void stackDump();			// debug
	void groupDump(int group_no, int **group, int *group_cnt);	// debug

	unsigned int getCount() const;		// return number of rules

	bool isStatic();			// returns wether eqation defines static operation or not

	static bool isNumber(const QString& str);

protected:
	virtual int pushOperand(const QString&, int length, int current_offset);
	virtual void pushOperation(const QString&, int length, int current_offset);
	virtual int getInputValue(int idx);

	CalcRules m_oCalcRules;
	int *m_poStack;				// calculation value stack
	int m_iStackItems;
	int m_iStackSize;

private:
	void checkStackSize(int iNeededSize);
	char * getOP(char *);			// return pointer to an operation contained in string
	// methods used for parsing equations
	const QueueInfo& parse(const char *, int current_offset);
	QueueInfo m_oParseInfo;

	int getBracket(char *);
	int getLeft(char *, char **);
	int getRight(char *, char **);

	QString m_sEquation;

	// the owner of the queue
	Device *m_dev;

	static QIntValidator intValidator;
};

#endif

