/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "regexps.h"
#include "debug.h"

#include <kdebug.h>

bool match_dversion(QString version)
{
  static QRegExp rx_revision(rxs_revision);
  QString allowed_vchars = ".+\\w";

  kdDebug(DEBUG_ZONE) << version << endl;
  if (version[1] == ':')
  {
    allowed_vchars += ":";
    if (! version[0].isDigit()) return false;
    kdDebug(DEBUG_ZONE) << "Matched epoch" << endl;
    version = version.right( version.length() - 2 );
  }

  kdDebug(DEBUG_ZONE) << version << endl;
  int rev_pos = version.findRev('-');
  if (rev_pos > -1)
  {
    allowed_vchars += "-";
    QString revision = version.right( version.length() - rev_pos - 1);
    if (! rx_revision.exactMatch(revision))
      return false;

    kdDebug(DEBUG_ZONE) << "Matched revision" << endl;
    version.truncate( version.length() - rev_pos - 1 );
  }

  QRegExp rx_version("\\d[" + allowed_vchars + "]*");
  return rx_version.exactMatch(version);
}
