/////////////////////////////////////////////////////////////////////////////
// Name:        setpage.cpp
// Purpose:     
// Author:      jean-pierre Charras
// Modified by: 
// Created:     13/11/2007 09:11:27
// RCS-ID:      
// Copyright:   License GNU
// Licence:     
/////////////////////////////////////////////////////////////////////////////

/* The "Page Settings" dialog box created by this file (and setpage.h)
 * contains seven checkboxes which *are* provided when that dialog box is
 * invoked in EESchema, but which are *not* provided when that dialog box is
 * invoked in Pcbnew instead. As such, various lines within this file
 * (and setpage.h) are included on an appropriately conditional basis.
 * (That aspect should be noted if the contents of this file (and setpage.h)
 * are ever consequently modified as a consequence of setpage.pjd being
 * opened in DialogBlocks (as that file now incorporates those checkboxes).)
 */

// Generated by DialogBlocks (unregistered), 13/11/2007 09:11:27

#if defined(__GNUG__) && !defined(NO_GCC_PRAGMA)
#pragma implementation "setpage.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes
#include "fctsys.h"
#include "gr_basic.h"

#include "common.h"

#ifdef EESCHEMA
#include "program.h"
#include "general.h"
#endif

#define NB_ITEMS 11
Ki_PageDescr * SheetList[NB_ITEMS + 1] =
{
    &g_Sheet_A4, &g_Sheet_A3, &g_Sheet_A2, &g_Sheet_A1, &g_Sheet_A0,
    &g_Sheet_A, &g_Sheet_B, &g_Sheet_C, &g_Sheet_D, &g_Sheet_E,
    &g_Sheet_user, NULL
};

#include "setpage.h"

////@begin XPM images

////@end XPM images

/******************************************************************/
void WinEDA_DrawFrame::Process_PageSettings(wxCommandEvent& event)
/******************************************************************/
/* Creation de la fenetre de configuration
 */
{
    WinEDA_SetPageFrame frame(this);
    frame.ShowModal();
    ReDrawPanel();
}

/*!
 * WinEDA_SetPageFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_SetPageFrame, wxDialog )


/*!
 * WinEDA_SetPageFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_SetPageFrame, wxDialog )

////@begin WinEDA_SetPageFrame event table entries
    EVT_CLOSE( WinEDA_SetPageFrame::OnCloseWindow )

    EVT_BUTTON( wxID_OK, WinEDA_SetPageFrame::OnOkClick )

    EVT_BUTTON( wxID_CANCEL, WinEDA_SetPageFrame::OnCancelClick )

////@end WinEDA_SetPageFrame event table entries

END_EVENT_TABLE()


/*!
 * WinEDA_SetPageFrame constructors
 */

WinEDA_SetPageFrame::WinEDA_SetPageFrame( )
{
    Init();
}

WinEDA_SetPageFrame::WinEDA_SetPageFrame( WinEDA_DrawFrame* parent, wxWindowID id,
                                          const wxString& caption, const wxPoint& pos,
                                          const wxSize& size, long style )
{
    Init();

    wxString msg;

    m_ParentDrawFrame = parent;
    m_Screen = m_ParentDrawFrame->m_CurrentScreen;
    m_Modified = FALSE;
    m_SelectedSheet = NULL;
    m_CurrentSelection = 0;
    SearchPageSizeSelection();
    Create(parent, id, caption, pos, size, style);
    // Init display value for sheet User size
    wxString format = m_TextSheetCount->GetLabel();
    msg.Printf(format, m_Screen->m_NumberOfSheet);
    m_TextSheetCount->SetLabel(msg);
    format = m_TextSheetNumber->GetLabel();
    msg.Printf(format, m_Screen->m_SheetNumber);
    m_TextSheetNumber->SetLabel(msg);
    if( g_UnitMetric )
    {
        UserSizeX = (double)g_Sheet_user.m_Size.x * 25.4 / 1000;
        UserSizeY = (double)g_Sheet_user.m_Size.y * 25.4 / 1000;
        msg.Printf( wxT("%.2f"), UserSizeX );
        m_TextUserSizeX->SetValue(msg);
        msg.Printf( wxT("%.2f"), UserSizeY );
        m_TextUserSizeY->SetValue(msg);
    }
    else
    {
        UserSizeX = (double)g_Sheet_user.m_Size.x / 1000;
        UserSizeY = (double)g_Sheet_user.m_Size.y / 1000;
        msg.Printf( wxT("%.3f"), UserSizeX );
        m_TextUserSizeX->SetValue(msg);
        msg.Printf( wxT("%.3f"), UserSizeY );
        m_TextUserSizeY->SetValue(msg);
    }
}


/*!
 * WinEDA_SetPageFrame creator
 */

bool WinEDA_SetPageFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin WinEDA_SetPageFrame creation
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if( GetSizer() )
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end WinEDA_SetPageFrame creation
    return true;
}


/*!
 * WinEDA_SetPageFrame destructor
 */

WinEDA_SetPageFrame::~WinEDA_SetPageFrame()
{
////@begin WinEDA_SetPageFrame destruction
////@end WinEDA_SetPageFrame destruction
}


/*!
 * Member initialisation
 */

void WinEDA_SetPageFrame::Init()
{

// NOTE: The following code has been modified by initialising the seven
// checkboxes *only* within the EESchema version of this dialog box.

////@begin WinEDA_SetPageFrame member initialisation
    OuterSizer = NULL;
    MainSizer = NULL;
    LeftColumnSizer = NULL;
    m_PageSizeBox = NULL;
    UserSizeXSizer = NULL;
    UserPageSizeX = NULL;
    m_TextUserSizeX = NULL;
    UserSizeYSizer = NULL;
    UserPageSizeY = NULL;
    m_TextUserSizeY = NULL;
    RightColumnSizer = NULL;
    SheetInfoSizer = NULL;
    m_TextSheetCount = NULL;
    m_TextSheetNumber = NULL;
    RevisionSizer = NULL;
    m_TextRevision = NULL;
    TitleSizer = NULL;
    m_TextTitle = NULL;
    CompanySizer = NULL;
    m_TextCompany = NULL;
    Comment1Sizer = NULL;
    m_TextComment1 = NULL;
    Comment2Sizer = NULL;
    m_TextComment2 = NULL;
    Comment3Sizer = NULL;
    m_TextComment3 = NULL;
    Comment4Sizer = NULL;
    m_TextComment4 = NULL;
    Line = NULL;
    StdDialogButtonSizer = NULL;
    Button_OK = NULL;
    Button_Cancel = NULL;

#ifdef EESCHEMA
    m_RevisionExport = NULL;
    m_TitleExport = NULL;
    m_CompanyExport = NULL;
    m_Comment1Export = NULL;
    m_Comment2Export = NULL;
    m_Comment3Export = NULL;
    m_Comment4Export = NULL;
#endif

////@end WinEDA_SetPageFrame member initialisation
}


/*!
 * Control creation for WinEDA_SetPageFrame
 */

void WinEDA_SetPageFrame::CreateControls()
{
    SetFont( *g_DialogFont );

// NOTE: The following code has been modified by providing the seven
// checkboxes *only* within the EESchema version of this dialog box.

////@begin WinEDA_SetPageFrame content construction
    // Generated by DialogBlocks, 13/11/2007 09:11:27 (unregistered)

    WinEDA_SetPageFrame* itemDialog1 = this;

    this->SetForegroundColour(wxColour(0, 128, 64));
    OuterSizer = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(OuterSizer);

    MainSizer = new wxBoxSizer(wxHORIZONTAL);
    OuterSizer->Add(MainSizer, 1, wxGROW|wxRIGHT|wxTOP|wxBOTTOM, 5);

    LeftColumnSizer = new wxFlexGridSizer(6, 1, 0, 0);
    LeftColumnSizer->AddGrowableRow(1);
    LeftColumnSizer->AddGrowableRow(2);
    LeftColumnSizer->AddGrowableRow(3);
    LeftColumnSizer->AddGrowableRow(4);
    LeftColumnSizer->AddGrowableRow(5);
    MainSizer->Add(LeftColumnSizer, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP, 5);

    wxArrayString m_PageSizeBoxStrings;
    m_PageSizeBoxStrings.Add(_("Size A4"));
    m_PageSizeBoxStrings.Add(_("Size A3"));
    m_PageSizeBoxStrings.Add(_("Size A2"));
    m_PageSizeBoxStrings.Add(_("Size A1"));
    m_PageSizeBoxStrings.Add(_("Size A0"));
    m_PageSizeBoxStrings.Add(_("Size A"));
    m_PageSizeBoxStrings.Add(_("Size B"));
    m_PageSizeBoxStrings.Add(_("Size C"));
    m_PageSizeBoxStrings.Add(_("Size D"));
    m_PageSizeBoxStrings.Add(_("Size E"));
    m_PageSizeBoxStrings.Add(_("User size"));
    m_PageSizeBox = new wxRadioBox( itemDialog1, ID_RADIOBOX_PAGE_SIZE, _("Page Size:"), wxDefaultPosition, wxDefaultSize, m_PageSizeBoxStrings, 1, wxRA_SPECIFY_COLS );
    m_PageSizeBox->SetSelection(0);
    LeftColumnSizer->Add(m_PageSizeBox, 1, wxGROW|wxALIGN_TOP|wxLEFT|wxRIGHT, 5);

    UserSizeXSizer = new wxBoxSizer(wxVERTICAL);
    LeftColumnSizer->Add(UserSizeXSizer, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxTOP, 5);

    UserPageSizeX = new wxStaticText( itemDialog1, wxID_STATIC, _("User Page Size X: "), wxDefaultPosition, wxDefaultSize, 0 );
    UserSizeXSizer->Add(UserPageSizeX, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);

    m_TextUserSizeX = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_USER_PAGE_SIZE_X, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    UserSizeXSizer->Add(m_TextUserSizeX, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT, 5);

    UserSizeYSizer = new wxBoxSizer(wxVERTICAL);
    LeftColumnSizer->Add(UserSizeYSizer, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxTOP, 5);

    UserPageSizeY = new wxStaticText( itemDialog1, wxID_STATIC, _("User Page Size Y: "), wxDefaultPosition, wxDefaultSize, 0 );
    UserSizeYSizer->Add(UserPageSizeY, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);

    m_TextUserSizeY = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_USER_PAGE_SIZE_Y, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    UserSizeYSizer->Add(m_TextUserSizeY, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT, 5);

    LeftColumnSizer->Add(5, 10, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

    LeftColumnSizer->Add(5, 10, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

    LeftColumnSizer->Add(5, 10, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

    RightColumnSizer = new wxFlexGridSizer(8, 1, 0, 0);
    RightColumnSizer->AddGrowableRow(0);
    RightColumnSizer->AddGrowableRow(1);
    RightColumnSizer->AddGrowableRow(2);
    RightColumnSizer->AddGrowableRow(3);
    RightColumnSizer->AddGrowableRow(4);
    RightColumnSizer->AddGrowableRow(5);
    RightColumnSizer->AddGrowableRow(6);
    RightColumnSizer->AddGrowableRow(7);
    RightColumnSizer->AddGrowableCol(0);
    MainSizer->Add(RightColumnSizer, 1, wxGROW|wxLEFT|wxRIGHT|wxTOP, 5);

    SheetInfoSizer = new wxBoxSizer(wxHORIZONTAL);
    RightColumnSizer->Add(SheetInfoSizer, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT, 5);

    m_TextSheetCount = new wxStaticText( itemDialog1, wxID_STATIC, _("Number of sheets: %d"), wxDefaultPosition, wxDefaultSize, 0 );
    m_TextSheetCount->SetForegroundColour(wxColour(128, 0, 128));
    SheetInfoSizer->Add(m_TextSheetCount, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM|wxADJUST_MINSIZE, 5);

    SheetInfoSizer->Add(5, 5, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    m_TextSheetNumber = new wxStaticText( itemDialog1, wxID_STATIC, _("Sheet number: %d"), wxDefaultPosition, wxDefaultSize, 0 );
    m_TextSheetNumber->SetForegroundColour(wxColour(128, 0, 128));
    SheetInfoSizer->Add(m_TextSheetNumber, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM|wxADJUST_MINSIZE, 5);

    wxStaticBox* itemStaticBoxSizer20Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Revision:"));
    RevisionSizer = new wxStaticBoxSizer(itemStaticBoxSizer20Static, wxHORIZONTAL);
    itemStaticBoxSizer20Static->SetForegroundColour(wxColour(200, 0, 0));
    RightColumnSizer->Add(RevisionSizer, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM, 5);

    m_TextRevision = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_REVISION, _T(""), wxDefaultPosition, wxSize(100, -1), wxTE_RICH );
    RevisionSizer->Add(m_TextRevision, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

#ifdef EESCHEMA
    m_RevisionExport = new wxCheckBox( itemDialog1, ID_CHECKBOX_REVISION, _("Export to other sheets"), wxDefaultPosition, wxDefaultSize, 0 );
    m_RevisionExport->SetValue(false);
    RevisionSizer->Add(m_RevisionExport, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);
#endif

    wxStaticBox* itemStaticBoxSizer23Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Title:"));
    TitleSizer = new wxStaticBoxSizer(itemStaticBoxSizer23Static, wxHORIZONTAL);
    itemStaticBoxSizer23Static->SetForegroundColour(wxColour(200, 0, 0));
    RightColumnSizer->Add(TitleSizer, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxADJUST_MINSIZE, 5);

    m_TextTitle = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_TITLE, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    TitleSizer->Add(m_TextTitle, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

#ifdef EESCHEMA
    m_TitleExport = new wxCheckBox( itemDialog1, ID_CHECKBOX_TITLE, _("Export to other sheets"), wxDefaultPosition, wxDefaultSize, 0 );
    m_TitleExport->SetValue(false);
    TitleSizer->Add(m_TitleExport, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);
#endif

    wxStaticBox* itemStaticBoxSizer26Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Company:"));
    CompanySizer = new wxStaticBoxSizer(itemStaticBoxSizer26Static, wxHORIZONTAL);
    itemStaticBoxSizer26Static->SetForegroundColour(wxColour(200, 0, 0));
    RightColumnSizer->Add(CompanySizer, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxADJUST_MINSIZE, 5);

    m_TextCompany = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_COMPANY, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    CompanySizer->Add(m_TextCompany, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

#ifdef EESCHEMA
    m_CompanyExport = new wxCheckBox( itemDialog1, ID_CHECKBOX_COMPANY, _("Export to other sheets"), wxDefaultPosition, wxDefaultSize, 0 );
    m_CompanyExport->SetValue(false);
    CompanySizer->Add(m_CompanyExport, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);
#endif

    wxStaticBox* itemStaticBoxSizer29Static = new wxStaticBox(itemDialog1, wxID_STATIC, _("Comment1:"));
    Comment1Sizer = new wxStaticBoxSizer(itemStaticBoxSizer29Static, wxHORIZONTAL);
    itemStaticBoxSizer29Static->SetForegroundColour(wxColour(196, 0, 100));
    RightColumnSizer->Add(Comment1Sizer, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxADJUST_MINSIZE, 5);

    m_TextComment1 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_COMMENT1, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    Comment1Sizer->Add(m_TextComment1, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

#ifdef EESCHEMA
    m_Comment1Export = new wxCheckBox( itemDialog1, ID_CHECKBOX_COMMENT1, _("Export to other sheets"), wxDefaultPosition, wxDefaultSize, 0 );
    m_Comment1Export->SetValue(false);
    Comment1Sizer->Add(m_Comment1Export, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);
#endif

    wxStaticBox* itemStaticBoxSizer32Static = new wxStaticBox(itemDialog1, wxID_STATIC, _("Comment2:"));
    Comment2Sizer = new wxStaticBoxSizer(itemStaticBoxSizer32Static, wxHORIZONTAL);
    itemStaticBoxSizer32Static->SetForegroundColour(wxColour(196, 0, 100));
    RightColumnSizer->Add(Comment2Sizer, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxADJUST_MINSIZE, 5);

    m_TextComment2 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_COMMENT2, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    Comment2Sizer->Add(m_TextComment2, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

#ifdef EESCHEMA
    m_Comment2Export = new wxCheckBox( itemDialog1, ID_CHECKBOX_COMMENT2, _("Export to other sheets"), wxDefaultPosition, wxDefaultSize, 0 );
    m_Comment2Export->SetValue(false);
    Comment2Sizer->Add(m_Comment2Export, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);
#endif

    wxStaticBox* itemStaticBoxSizer35Static = new wxStaticBox(itemDialog1, wxID_STATIC, _("Comment3:"));
    Comment3Sizer = new wxStaticBoxSizer(itemStaticBoxSizer35Static, wxHORIZONTAL);
    itemStaticBoxSizer35Static->SetForegroundColour(wxColour(196, 0, 100));
    RightColumnSizer->Add(Comment3Sizer, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxADJUST_MINSIZE, 5);

    m_TextComment3 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_COMMENT3, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    Comment3Sizer->Add(m_TextComment3, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

#ifdef EESCHEMA
    m_Comment3Export = new wxCheckBox( itemDialog1, ID_CHECKBOX_COMMENT3, _("Export to other sheets"), wxDefaultPosition, wxDefaultSize, 0 );
    m_Comment3Export->SetValue(false);
    Comment3Sizer->Add(m_Comment3Export, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);
#endif

    wxStaticBox* itemStaticBoxSizer38Static = new wxStaticBox(itemDialog1, wxID_STATIC, _("Comment4:"));
    Comment4Sizer = new wxStaticBoxSizer(itemStaticBoxSizer38Static, wxHORIZONTAL);
    itemStaticBoxSizer38Static->SetForegroundColour(wxColour(196, 0, 100));
    RightColumnSizer->Add(Comment4Sizer, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxADJUST_MINSIZE, 5);

    m_TextComment4 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_COMMENT4, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    Comment4Sizer->Add(m_TextComment4, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

#ifdef EESCHEMA
    m_Comment4Export = new wxCheckBox( itemDialog1, ID_CHECKBOX_COMMENT4, _("Export to other sheets"), wxDefaultPosition, wxDefaultSize, 0 );
    m_Comment4Export->SetValue(false);
    Comment4Sizer->Add(m_Comment4Export, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);
#endif

    Line = new wxStaticLine( itemDialog1, ID_STATICLINE, wxDefaultPosition, wxDefaultSize, wxLI_HORIZONTAL );
    OuterSizer->Add(Line, 0, wxGROW|wxLEFT|wxRIGHT, 5);

    StdDialogButtonSizer = new wxStdDialogButtonSizer;

    OuterSizer->Add(StdDialogButtonSizer, 0, wxGROW|wxALL, 10);
    Button_OK = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    Button_OK->SetForegroundColour(wxColour(200, 0, 0));
    StdDialogButtonSizer->AddButton(Button_OK);

    Button_Cancel = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    Button_Cancel->SetForegroundColour(wxColour(0, 0, 255));
    StdDialogButtonSizer->AddButton(Button_Cancel);

    StdDialogButtonSizer->Realize();


    // Set validators
    m_PageSizeBox->SetValidator( wxGenericValidator(& m_CurrentSelection) );
    m_TextRevision->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Revision) );
    m_TextTitle->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Title) );
    m_TextCompany->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Company) );
    m_TextComment1->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire1) );
    m_TextComment2->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire2) );
    m_TextComment3->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire3) );
    m_TextComment4->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire4) );
////@end WinEDA_SetPageFrame content construction
}


/*!
 * wxEVT_CLOSE_WINDOW event handler for ID_DIALOG
 */

void WinEDA_SetPageFrame::OnCloseWindow( wxCloseEvent& event )
{
    EndModal( m_Modified );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void WinEDA_SetPageFrame::OnOkClick( wxCommandEvent& event )
{
    SavePageSettings( event );
    Close( TRUE );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_SetPageFrame::OnCancelClick( wxCommandEvent& event )
{
    Close( TRUE );
}


/*!
 * Should we show tooltips?
 */

bool WinEDA_SetPageFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_SetPageFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_SetPageFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_SetPageFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon WinEDA_SetPageFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_SetPageFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_SetPageFrame icon retrieval
}


/*****************************************************************/
void WinEDA_SetPageFrame::SavePageSettings(wxCommandEvent& event)
/*****************************************************************/
/* Mise a jour effective des textes et dimensions
 */
{
    double dtmp;
    wxString msg;

    m_Screen->m_Revision = m_TextRevision->GetValue();
    m_Screen->m_Company = m_TextCompany->GetValue();
    m_Screen->m_Title = m_TextTitle->GetValue();
    m_Screen->m_Commentaire1 = m_TextComment1->GetValue();
    m_Screen->m_Commentaire2 = m_TextComment2->GetValue();
    m_Screen->m_Commentaire3 = m_TextComment3->GetValue();
    m_Screen->m_Commentaire4 = m_TextComment4->GetValue();

    msg = m_TextUserSizeX->GetValue();
    msg.ToDouble(&dtmp);
    UserSizeX = dtmp;
    msg = m_TextUserSizeY->GetValue();
    msg.ToDouble(&dtmp);
    UserSizeY = dtmp;

    int ii = m_PageSizeBox->GetSelection();

    if( ii < 0 )
        ii = 0;

    m_SelectedSheet = SheetList[ii];
    m_Screen->m_CurrentSheet = m_SelectedSheet;

    if( g_UnitMetric )
    {
        g_Sheet_user.m_Size.x = (int)( UserSizeX * 1000 / 25.4 );
        g_Sheet_user.m_Size.y = (int)( UserSizeY * 1000 / 25.4 );
    }
    else
    {
        g_Sheet_user.m_Size.x = (int)( UserSizeX * 1000 );
        g_Sheet_user.m_Size.y = (int)( UserSizeY * 1000 );
    }

    if( g_Sheet_user.m_Size.x < 6000 )
        g_Sheet_user.m_Size.x = 6000;

    if( g_Sheet_user.m_Size.x > 44000 )
        g_Sheet_user.m_Size.x = 44000;

    if( g_Sheet_user.m_Size.y < 4000 )
        g_Sheet_user.m_Size.y = 4000;

    if( g_Sheet_user.m_Size.y > 44000 )
        g_Sheet_user.m_Size.y = 44000;

#ifdef EESCHEMA
    /* Exports settings to other sheets if requested: */
    SCH_SCREEN * screen;
    /* Build the screen list */
    EDA_ScreenList ScreenList(NULL);
    /* Update the datas */
    for( screen = ScreenList.GetFirst(); screen != NULL; screen = ScreenList.GetNext() )
    {
        if( screen == m_Screen )
            continue;

        if( m_RevisionExport->IsChecked() )
            screen->m_Revision = m_Screen->m_Revision;

        if( m_TitleExport->IsChecked() )
            screen->m_Title =m_Screen->m_Title;

        if( m_CompanyExport->IsChecked() )
            screen->m_Company = m_Screen->m_Company;

        if( m_Comment1Export->IsChecked() )
            screen->m_Commentaire1 = m_Screen->m_Commentaire1;

        if( m_Comment2Export->IsChecked() )
            screen->m_Commentaire2 = m_Screen->m_Commentaire2;

        if( m_Comment3Export->IsChecked() )
            screen->m_Commentaire3 = m_Screen->m_Commentaire3;

        if( m_Comment4Export->IsChecked() )
            screen->m_Commentaire4 = m_Screen->m_Commentaire4;
    }
#endif

    m_Screen->SetModify();
    m_Screen->SetRefreshReq();
}


/*******************************************************/
void WinEDA_SetPageFrame::SearchPageSizeSelection()
/*******************************************************/
/* Search the correct index to activate the radiobox list size selection
 * according to the current page size
 */
{
    Ki_PageDescr * sheet;
    int ii;

    m_CurrentSelection = NB_ITEMS - 1;
    for( ii = 0; ii < NB_ITEMS; ii++ )
    {
        sheet = SheetList[ii];
        if( m_ParentDrawFrame->m_CurrentScreen->m_CurrentSheet == sheet )
            m_CurrentSelection = ii;
    }
}
