/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : 
 * 
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#ifndef PREVIEWDLG_H
#define PREVIEWDLG_H

#include "preview.h"

#include <kurl.h>

class KURL;

/**
 * Provide a larger preview of a photograph
 * @short Display large photo preview
 * @author M. Asselstine
*/
class PreviewDlg : public PreviewUI
{
Q_OBJECT

public:
    /**
     * Constructor.
     * @param parent Pointer to parent widget
     * @param name Widget name for this dialog
     */
    PreviewDlg(QWidget *parent = 0, const char *name = 0);

    /** Destructor */
    ~PreviewDlg();

    /**
     * Set the URL and the rotation of the photo to preview.
     * @param url URL of the file for the photo
     * @param rotation Rotation in degrees to apply to the photo preview image.
     */
    void displayPhoto(const KURL &url, int rotation);
};

#endif // PREVIEWDLG_H
