/*
 * kwin_skulpture_config.cpp - Skulpture window decoration for KDE
 *
 * modified version of kwin/clients/quartz/config/config.cpp
 *
 */

/********************************************************************

 	This file contains the quartz configuration widget

 	Copyright (c) 2001
 		Karol Szwed <gallium@kde.org>
 		http://gallium.n3.net/

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*********************************************************************/

#include "kwin_skulpture_config.h"
#include <KDE/KGlobal>
#include <KDE/KConfig>
#include <KDE/KConfigGroup>
#include <KDE/KLocale>
#include <KDE/KVBox>
#include <QtGui/QCheckBox>


/*-----------------------------------------------------------------------*/

extern "C" KDE_EXPORT QObject *allocate_config(KConfig *conf, QWidget *parent)
{
	return new SkulptureConfig(conf, parent);
}


/*-----------------------------------------------------------------------*/

/* NOTE:
 * 'conf' 	is a pointer to the kwindecoration modules open kwin config,
 *			and is by default set to the "Style" group.
 *
 * 'parent'	is the parent of the QObject, which is a VBox inside the
 *			Configure tab in kwindecoration
 */

SkulptureConfig::SkulptureConfig(KConfig *conf, QWidget *parent)
	: QObject(parent)
{
	Q_UNUSED(conf);
	skulptureConfig = new KConfig(QLatin1String("kwinskulpturerc"));
	KConfigGroup cg(skulptureConfig, "General");
	KGlobal::locale()->insertCatalog(QLatin1String("kwin_clients"));
	gb = new KVBox(parent);
	cbColorBorder = new QCheckBox(i18n("Draw window frames using &titlebar colors"), gb);
	cbColorBorder->setWhatsThis(
	 i18n("When selected, the window decoration borders "
	 "are drawn using the titlebar colors; otherwise, they are "
	 "drawn using normal border colors instead."));
	cbContrastBorder = new QCheckBox(i18n("Add e&xtra border for better contrast"), gb);
	cbContrastBorder->setWhatsThis(
	 i18n("When selected, an additional dark border is drawn "
	"around the window decoration borders. This increases the "
	"contrast on window managers that do not add shadows."));
        cbShowIcon = new QCheckBox(i18n("Use application &icon instead of menu symbol"), gb);
	// Load configuration options
	load(cg);

	// Ensure we track user changes properly
	connect(cbColorBorder, SIGNAL(clicked()), this, SLOT(slotSelectionChanged()));
	connect(cbContrastBorder, SIGNAL(clicked()), this, SLOT(slotSelectionChanged()));
        connect(cbShowIcon, SIGNAL(clicked()), this, SLOT(slotSelectionChanged()));

	// Make the widgets visible in kwindecoration
	gb->show();
}


SkulptureConfig::~SkulptureConfig()
{
	delete gb;
	delete skulptureConfig;
}


void SkulptureConfig::slotSelectionChanged()
{
	Q_EMIT changed();
}


// Loads the configurable options from the kwinrc config file
// It is passed the open config from kwindecoration to improve efficiency
void SkulptureConfig::load( const KConfigGroup& /*conf*/ )
{
	KConfigGroup cg(skulptureConfig, "General");
	bool override = cg.readEntry( "UseTitleBarBorderColors", false);
	cbColorBorder->setChecked( override );
	override = cg.readEntry( "UseExtraContrastBorder", false);
	cbContrastBorder->setChecked( override );
        override = cg.readEntry( "UseApplicationIcon", true);
        cbShowIcon->setChecked( override );
}


// Saves the configurable options to the kwinrc config file
void SkulptureConfig::save( KConfigGroup& /*conf*/ )
{
	KConfigGroup cg(skulptureConfig, "General");
	cg.writeEntry( "UseTitleBarBorderColors", cbColorBorder->isChecked() );
	cg.writeEntry( "UseExtraContrastBorder", cbContrastBorder->isChecked() );
        cg.writeEntry( "UseApplicationIcon", cbShowIcon->isChecked() );
	// Ensure others trying to read this config get updated
	skulptureConfig->sync();
}


// Sets UI widget defaults which must correspond to style defaults
void SkulptureConfig::defaults()
{
	cbColorBorder->setChecked( false );
	cbContrastBorder->setChecked( false );
        cbShowIcon->setChecked( true );
}


/*-----------------------------------------------------------------------*/

#include "kwin_skulpture_config.moc"


