/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXWEBQUERYIEEEXPLORE_H
#define KBIBTEXWEBQUERYIEEEXPLORE_H

#include <qregexp.h>

#include <webquery.h>
#include <fileimporter.h>

namespace KBibTeX
{
    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryIEEExploreWidget : public WebQueryWidget
    {
        Q_OBJECT
    public:
        WebQueryIEEExploreWidget( QWidget *parent, const char *name = 0 );
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */

    class WebQueryIEEExplore : public WebQuery
    {
        Q_OBJECT
    public:
        WebQueryIEEExplore( QWidget* parent );
        virtual ~WebQueryIEEExplore();

        void query();

        QString title();
        QString disclaimer();
        QString disclaimerURL();

        WebQueryWidget *widget();

    protected:
        void cancelQuery() { /* nothing */ };

    private:
        BibTeX::FileImporter *m_bibtexImporter;
        WebQueryIEEExploreWidget *m_widget;
        QRegExp m_numberOfMatches;
        QRegExp m_findArNumber;
        QRegExp m_date;
        KURL m_risURL;
        QValueList<int> m_arnumList;
        QString m_incomingData;
        int m_numMaxHits, m_numMatches, m_hitCounter;

        void fetchNext();
        void fixDate( BibTeX::Entry *entry );
        QString parseMonth( const QString &month );

    private slots:
        void slotData( KIO::Job *job, const QByteArray &data );
        void slotResult( KIO::Job *job );
    };
}

#endif
