// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2004 Hiroyuki Ikezoe
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kz-mozdownloader.h"
#include <glib/gi18n.h>

#include "kazehakase.h"
#include "kz-mozprogresslistener.h"

typedef struct _KzMozDownloaderPrivate KzMozDownloaderPrivate;
struct _KzMozDownloaderPrivate
{
	KzMozProgressListener *mProgress;
};
#define KZ_MOZ_DOWNLOADER_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), KZ_TYPE_MOZ_DOWNLOADER, KzMozDownloaderPrivate))

static void dispose       (GObject    *object);

static gint kz_moz_downloader_get_percent   (KzDownloader *downloader);
static void kz_moz_downloader_cancel        (KzDownloader *downloader);

G_DEFINE_TYPE(KzMozDownloader, kz_moz_downloader, KZ_TYPE_DOWNLOADER)

static void
kz_moz_downloader_class_init (KzMozDownloaderClass *klass)
{
	GObjectClass *object_class;
	KzDownloaderClass *dl_class;

	object_class    = G_OBJECT_CLASS(klass);
	dl_class        = KZ_DOWNLOADER_CLASS(klass);

	object_class->dispose  = dispose;

	dl_class->kz_downloader_get_percent = kz_moz_downloader_get_percent;
	dl_class->kz_downloader_cancel      = kz_moz_downloader_cancel;
	g_type_class_add_private(object_class, sizeof(KzMozDownloaderPrivate));
}


static void
kz_moz_downloader_init (KzMozDownloader *kzdl)
{
	KzMozDownloaderPrivate *priv = KZ_MOZ_DOWNLOADER_GET_PRIVATE (kzdl);
	
	priv->mProgress = NULL;
}

KzMozDownloader *
kz_moz_downloader_new (gpointer aProgress, const gchar *filename)
{
	KzMozDownloader *kzdl;
	KzMozDownloaderPrivate *priv;

	kzdl = KZ_MOZ_DOWNLOADER(
		g_object_new(KZ_TYPE_MOZ_DOWNLOADER,
			     "file-name", filename,
			     NULL));

	priv = KZ_MOZ_DOWNLOADER_GET_PRIVATE (kzdl);
	priv->mProgress = (KzMozProgressListener*)aProgress;

	return kzdl;
}

static void
dispose (GObject *object)
{
	KzMozDownloader *kzdl = KZ_MOZ_DOWNLOADER(object);
	KzMozDownloaderPrivate *priv = KZ_MOZ_DOWNLOADER_GET_PRIVATE (kzdl);
	priv->mProgress = NULL;

	if (G_OBJECT_CLASS (kz_moz_downloader_parent_class)->dispose)
		G_OBJECT_CLASS (kz_moz_downloader_parent_class)->dispose(object);
}


static	gint
kz_moz_downloader_get_percent (KzDownloader *downloader)
{
	KzMozDownloader *kzdl;
	KzMozDownloaderPrivate *priv;
	gint percent;
	
	g_return_val_if_fail(KZ_IS_MOZ_DOWNLOADER(downloader), -1);
	
	kzdl = KZ_MOZ_DOWNLOADER(downloader);

	priv = KZ_MOZ_DOWNLOADER_GET_PRIVATE (kzdl);
	priv->mProgress->GetPercentComplete(&percent);

	return percent;
}

static void
kz_moz_downloader_cancel (KzDownloader *downloader)
{
	KzMozDownloader *kzdl;
	KzMozDownloaderPrivate *priv;
	
	g_return_if_fail(KZ_IS_MOZ_DOWNLOADER(downloader));
	
	kzdl = KZ_MOZ_DOWNLOADER(downloader);
	priv = KZ_MOZ_DOWNLOADER_GET_PRIVATE (kzdl);

	priv->mProgress->Cancel();
}
