/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Mozilla browser.
 * 
 * The Initial Developer of the Original Code is Netscape
 * Communications, Inc.  Portions created by Netscape are
 * Copyright (C) 1999, Mozilla.  All Rights Reserved.
 * 
 * Author:
 *   Adam Lock <adamlock@netscape.com>
 *
 * Contributor(s):
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#define MOZILLA_INTERNAL_API
#include <nsIServiceManager.h>
#undef MOZILLA_INTERNAL_API
#include <nsIComponentRegistrar.h>
#include <nsIAppStartupNotifier.h>
#include <nsIStringBundle.h>
#include <nsCOMPtr.h>

#include <nsIDirectoryService.h>
#include <nsDirectoryServiceDefs.h>
#include <nsXPCOM.h>

#include <nsEmbedAPI.h>

static nsIServiceManager *sServiceManager = nsnull;
static PRBool             sRegistryInitializedFlag = PR_FALSE;
static PRUint32           sInitCounter = 0;

#define HACK_AROUND_THREADING_ISSUES
//#define HACK_AROUND_NONREENTRANT_INITXPCOM

#ifdef HACK_AROUND_NONREENTRANT_INITXPCOM
// XXX hack class to clean up XPCOM when this module is unloaded
class XPCOMCleanupHack
{
public:
    PRBool mCleanOnExit;

    XPCOMCleanupHack() : mCleanOnExit(PR_FALSE) {}
    ~XPCOMCleanupHack()
    {
        if (mCleanOnExit)
        {
            if (sInitCounter > 0)
            {
                sInitCounter = 1;
                NS_TermEmbedding();
            }
            // XXX Global destructors and NS_ShutdownXPCOM don't seem to mix
//          NS_ShutdownXPCOM(sServiceManager);
        }
    }
};
static PRBool sXPCOMInitializedFlag = PR_FALSE;
static XPCOMCleanupHack sXPCOMCleanupHack;
#endif


NS_METHOD
NS_InitEmbedding(nsILocalFile *mozBinDirectory,
                 nsIDirectoryServiceProvider *appFileLocProvider,
                 nsStaticModuleInfo const *aStaticComponents,
                 PRUint32 aStaticComponentCount)
{
    nsresult rv;

    // Reentrant calls to this method do nothing except increment a counter
    sInitCounter++;
    if (sInitCounter > 1)
        return NS_OK;

    // Initialise XPCOM
#ifdef HACK_AROUND_NONREENTRANT_INITXPCOM
    // Can't call NS_InitXPCom more than once or things go boom!
    if (!sXPCOMInitializedFlag)
#endif
    {
        // Initialise XPCOM
        rv = NS_InitXPCOM3(&sServiceManager, mozBinDirectory, appFileLocProvider,
                           aStaticComponents, aStaticComponentCount);
        NS_ENSURE_SUCCESS(rv, rv);
                
#ifdef HACK_AROUND_NONREENTRANT_INITXPCOM
        sXPCOMInitializedFlag = PR_TRUE;
        sXPCOMCleanupHack.mCleanOnExit = PR_TRUE;
#endif
    }
    // Register components
    if (!sRegistryInitializedFlag)
    {
#ifdef HAVE_GECKO_1_8
        nsIComponentRegistrar *registrar;
        rv = sServiceManager->QueryInterface(NS_GET_IID(nsIComponentRegistrar),
                                             (void **) &registrar);
#else
        nsCOMPtr<nsIComponentRegistrar> registrar = do_QueryInterface(sServiceManager, &rv);
#endif
        sRegistryInitializedFlag = PR_TRUE;
    }

#ifdef HAVE_GECKO_1_8
    nsIComponentManager *compMgr;
    rv = sServiceManager->QueryInterface(NS_GET_IID(nsIComponentManager),
                                         (void **) &compMgr);
    if (NS_FAILED(rv))
        return rv;

    nsIObserver *startupNotifier;
    rv = compMgr->CreateInstanceByContractID(NS_APPSTARTUPNOTIFIER_CONTRACTID,
                                             NULL,
                                             NS_GET_IID(nsIObserver),
                                             (void **) &startupNotifier);
    NS_RELEASE(compMgr);
    if (NS_FAILED(rv))
        return rv;

	  startupNotifier->Observe(nsnull, APPSTARTUP_TOPIC, nsnull);
    NS_RELEASE(startupNotifier);

#else
	nsCOMPtr<nsIObserver> mStartupNotifier = do_CreateInstance(NS_APPSTARTUPNOTIFIER_CONTRACTID, &rv);
	if(NS_FAILED(rv))
		return rv;
	mStartupNotifier->Observe(nsnull, APPSTARTUP_TOPIC, nsnull);
#endif

#ifdef HACK_AROUND_THREADING_ISSUES
#ifdef HAVE_GECKO_1_8
    // XXX force certain objects to be created on the main thread
    nsIStringBundleService *bundleService;
    rv = sServiceManager->GetServiceByContractID(NS_STRINGBUNDLE_CONTRACTID,
                                                 NS_GET_IID(nsIStringBundleService),
                                                 (void **) &bundleService);
    if (NS_SUCCEEDED(rv))
    {
        nsIStringBundle *stringBundle;
        const char propertyURL[] = "chrome://necko/locale/necko.properties";
        rv = bundleService->CreateBundle(propertyURL, &stringBundle);
        NS_RELEASE(stringBundle);
        NS_RELEASE(bundleService);
    }
#else
    // XXX force certain objects to be created on the main thread
    nsCOMPtr<nsIStringBundleService> sBundleService;
    sBundleService = do_GetService(NS_STRINGBUNDLE_CONTRACTID, &rv);
    if (NS_SUCCEEDED(rv))
    {
        nsCOMPtr<nsIStringBundle> stringBundle;
        const char propertyURL[] = "chrome://necko/locale/necko.properties";
        rv = sBundleService->CreateBundle(propertyURL,
                                          getter_AddRefs(stringBundle));
    }
#endif
#endif

    return NS_OK;

}

#ifdef HAVE_GECKO_1_8
NS_METHOD
NS_TermEmbedding()
#else
nsresult NS_TermEmbedding()
#endif
{
    // Reentrant calls to this method do nothing except decrement a counter
    if (sInitCounter > 1)
    {
        sInitCounter--;
        return NS_OK;
    }
    sInitCounter = 0;

    NS_IF_RELEASE(sServiceManager);

    // Terminate XPCOM & cleanup
#ifndef HACK_AROUND_NONREENTRANT_INITXPCOM
    nsresult rv = NS_ShutdownXPCOM(sServiceManager);
    NS_ENSURE_SUCCESS(rv, rv);
#endif

    return NS_OK;
}
